/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes2) {
        super(tag, baseUri, attributes2);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    @Override
    protected void removeChild(Node out2) {
        super.removeChild(out2);
        this.elements.remove(out2);
    }

    public Connection submit() {
        String action = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method2 = this.attr("method").equalsIgnoreCase("POST") ? Connection.Method.POST : Connection.Method.GET;
        Document owner = this.ownerDocument();
        Connection connection = owner != null ? owner.connection().newRequest() : Jsoup.newSession();
        return connection.url(action).data(this.formData()).method(method2);
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data2 = new ArrayList<Connection.KeyVal>();
        for (Element el : this.elements) {
            String type2;
            String name;
            if (!el.tag().isFormSubmittable() || el.hasAttr("disabled") || (name = el.attr("name")).length() == 0 || (type2 = el.attr("type")).equalsIgnoreCase("button")) continue;
            if ("select".equals(el.normalName())) {
                Element option2;
                Elements options2 = el.select("option[selected]");
                boolean set2 = false;
                for (Element option3 : options2) {
                    data2.add(HttpConnection.KeyVal.create(name, option3.val()));
                    set2 = true;
                }
                if (set2 || (option2 = el.selectFirst("option")) == null) continue;
                data2.add(HttpConnection.KeyVal.create(name, option2.val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(type2) || "radio".equalsIgnoreCase(type2)) {
                if (!el.hasAttr("checked")) continue;
                String val = el.val().length() > 0 ? el.val() : "on";
                data2.add(HttpConnection.KeyVal.create(name, val));
                continue;
            }
            data2.add(HttpConnection.KeyVal.create(name, el.val()));
        }
        return data2;
    }

    @Override
    public FormElement clone() {
        return (FormElement)super.clone();
    }
}

