/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.UncheckedIOException;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.helper.CookieUtil;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.Validate;
import org.jsoup.internal.ConstrainableInputStream;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TokenQueue;

public class HttpConnection
implements Connection {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String DEFAULT_UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36";
    private static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final int HTTP_TEMP_REDIR = 307;
    private static final String DefaultUploadType = "application/octet-stream";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private Request req;
    @Nullable
    private Connection.Response res;

    public static Connection connect(String url2) {
        HttpConnection con = new HttpConnection();
        con.url(url2);
        return con;
    }

    public static Connection connect(URL url2) {
        HttpConnection con = new HttpConnection();
        con.url(url2);
        return con;
    }

    public HttpConnection() {
        this.req = new Request();
    }

    HttpConnection(Request copy2) {
        this.req = new Request(copy2);
    }

    private static String encodeUrl(String url2) {
        try {
            URL u = new URL(url2);
            return HttpConnection.encodeUrl(u).toExternalForm();
        }
        catch (Exception e) {
            return url2;
        }
    }

    static URL encodeUrl(URL u) {
        u = HttpConnection.punyUrl(u);
        try {
            String urlS = u.toExternalForm();
            urlS = urlS.replace(" ", "%20");
            URI uri2 = new URI(urlS);
            return new URL(uri2.toASCIIString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            return u;
        }
    }

    private static URL punyUrl(URL url2) {
        if (!StringUtil.isAscii(url2.getHost())) {
            try {
                String puny = IDN.toASCII(url2.getHost());
                url2 = new URL(url2.getProtocol(), puny, url2.getPort(), url2.getFile());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return url2;
    }

    private static String encodeMimeName(String val) {
        return val.replace("\"", "%22");
    }

    @Override
    public Connection newRequest() {
        return new HttpConnection(this.req);
    }

    private HttpConnection(Request req, Response res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public Connection url(URL url2) {
        this.req.url(url2);
        return this;
    }

    @Override
    public Connection url(String url2) {
        Validate.notEmpty(url2, "Must supply a valid URL");
        try {
            this.req.url(new URL(HttpConnection.encodeUrl(url2)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url2, e);
        }
        return this;
    }

    @Override
    public Connection proxy(@Nullable Proxy proxy) {
        this.req.proxy(proxy);
        return this;
    }

    @Override
    public Connection proxy(String host2, int port2) {
        this.req.proxy(host2, port2);
        return this;
    }

    @Override
    public Connection userAgent(String userAgent) {
        Validate.notNull(userAgent, "User agent must not be null");
        this.req.header(USER_AGENT, userAgent);
        return this;
    }

    @Override
    public Connection timeout(int millis) {
        this.req.timeout(millis);
        return this;
    }

    @Override
    public Connection maxBodySize(int bytes) {
        this.req.maxBodySize(bytes);
        return this;
    }

    @Override
    public Connection followRedirects(boolean followRedirects) {
        this.req.followRedirects(followRedirects);
        return this;
    }

    @Override
    public Connection referrer(String referrer) {
        Validate.notNull(referrer, "Referrer must not be null");
        this.req.header("Referer", referrer);
        return this;
    }

    @Override
    public Connection method(Connection.Method method2) {
        this.req.method(method2);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.req.ignoreHttpErrors(ignoreHttpErrors);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean ignoreContentType) {
        this.req.ignoreContentType(ignoreContentType);
        return this;
    }

    @Override
    public Connection data(String key2, String value) {
        this.req.data(KeyVal.create(key2, value));
        return this;
    }

    @Override
    public Connection sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.req.sslSocketFactory(sslSocketFactory);
        return this;
    }

    @Override
    public Connection data(String key2, String filename, InputStream inputStream2) {
        this.req.data(KeyVal.create(key2, filename, inputStream2));
        return this;
    }

    @Override
    public Connection data(String key2, String filename, InputStream inputStream2, String contentType2) {
        this.req.data(KeyVal.create(key2, filename, inputStream2).contentType(contentType2));
        return this;
    }

    @Override
    public Connection data(Map<String, String> data2) {
        Validate.notNull(data2, "Data map must not be null");
        for (Map.Entry<String, String> entry : data2.entrySet()) {
            this.req.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... keyvals) {
        Validate.notNull(keyvals, "Data key value pairs must not be null");
        Validate.isTrue(keyvals.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i2 = 0; i2 < keyvals.length; i2 += 2) {
            String key2 = keyvals[i2];
            String value = keyvals[i2 + 1];
            Validate.notEmpty(key2, "Data key must not be empty");
            Validate.notNull(value, "Data value must not be null");
            this.req.data(KeyVal.create(key2, value));
        }
        return this;
    }

    @Override
    public Connection data(Collection<Connection.KeyVal> data2) {
        Validate.notNull(data2, "Data collection must not be null");
        for (Connection.KeyVal entry : data2) {
            this.req.data(entry);
        }
        return this;
    }

    @Override
    public Connection.KeyVal data(String key2) {
        Validate.notEmpty(key2, "Data key must not be empty");
        for (Connection.KeyVal keyVal : this.request().data()) {
            if (!keyVal.key().equals(key2)) continue;
            return keyVal;
        }
        return null;
    }

    @Override
    public Connection requestBody(String body2) {
        this.req.requestBody(body2);
        return this;
    }

    @Override
    public Connection header(String name, String value) {
        this.req.header(name, value);
        return this;
    }

    @Override
    public Connection headers(Map<String, String> headers2) {
        Validate.notNull(headers2, "Header map must not be null");
        for (Map.Entry<String, String> entry : headers2.entrySet()) {
            this.req.header(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection cookie(String name, String value) {
        this.req.cookie(name, value);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> cookies2) {
        Validate.notNull(cookies2, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : cookies2.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection cookieStore(CookieStore cookieStore) {
        this.req.cookieManager = new CookieManager(cookieStore, null);
        return this;
    }

    @Override
    public CookieStore cookieStore() {
        return this.req.cookieManager.getCookieStore();
    }

    @Override
    public Connection parser(Parser parser) {
        this.req.parser(parser);
        return this;
    }

    @Override
    public Document get() throws IOException {
        this.req.method(Connection.Method.GET);
        this.execute();
        Validate.notNull(this.res);
        return this.res.parse();
    }

    @Override
    public Document post() throws IOException {
        this.req.method(Connection.Method.POST);
        this.execute();
        Validate.notNull(this.res);
        return this.res.parse();
    }

    @Override
    public Connection.Response execute() throws IOException {
        this.res = Response.execute(this.req);
        return this.res;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    @Override
    public Connection request(Connection.Request request) {
        this.req = (Request)request;
        return this;
    }

    @Override
    public Connection.Response response() {
        if (this.res == null) {
            throw new IllegalArgumentException("You must execute the request before getting a response.");
        }
        return this.res;
    }

    @Override
    public Connection response(Connection.Response response) {
        this.res = response;
        return this;
    }

    @Override
    public Connection postDataCharset(String charset) {
        this.req.postDataCharset(charset);
        return this;
    }

    private static boolean needsMultipart(Connection.Request req) {
        for (Connection.KeyVal keyVal : req.data()) {
            if (!keyVal.hasInputStream()) continue;
            return true;
        }
        return false;
    }

    public static class Request
    extends Base<Connection.Request>
    implements Connection.Request {
        @Nullable
        private Proxy proxy;
        private int timeoutMilliseconds;
        private int maxBodySizeBytes;
        private boolean followRedirects;
        private final Collection<Connection.KeyVal> data;
        @Nullable
        private String body = null;
        private boolean ignoreHttpErrors = false;
        private boolean ignoreContentType = false;
        private Parser parser;
        private boolean parserDefined = false;
        private String postDataCharset = DataUtil.defaultCharsetName;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        private CookieManager cookieManager;
        private volatile boolean executing = false;

        Request() {
            this.timeoutMilliseconds = 30000;
            this.maxBodySizeBytes = 0x200000;
            this.followRedirects = true;
            this.data = new ArrayList<Connection.KeyVal>();
            this.method = Connection.Method.GET;
            this.addHeader("Accept-Encoding", "gzip");
            this.addHeader(HttpConnection.USER_AGENT, HttpConnection.DEFAULT_UA);
            this.parser = Parser.htmlParser();
            this.cookieManager = new CookieManager();
        }

        Request(Request copy2) {
            super(copy2);
            this.proxy = copy2.proxy;
            this.postDataCharset = copy2.postDataCharset;
            this.timeoutMilliseconds = copy2.timeoutMilliseconds;
            this.maxBodySizeBytes = copy2.maxBodySizeBytes;
            this.followRedirects = copy2.followRedirects;
            this.data = new ArrayList<Connection.KeyVal>();
            this.data.addAll(copy2.data());
            this.body = copy2.body;
            this.ignoreHttpErrors = copy2.ignoreHttpErrors;
            this.ignoreContentType = copy2.ignoreContentType;
            this.parser = copy2.parser.newInstance();
            this.parserDefined = copy2.parserDefined;
            this.sslSocketFactory = copy2.sslSocketFactory;
            this.cookieManager = copy2.cookieManager;
            this.executing = false;
        }

        @Override
        public Proxy proxy() {
            return this.proxy;
        }

        @Override
        public Request proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Override
        public Request proxy(String host2, int port2) {
            this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host2, port2));
            return this;
        }

        @Override
        public int timeout() {
            return this.timeoutMilliseconds;
        }

        @Override
        public Request timeout(int millis) {
            Validate.isTrue(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.timeoutMilliseconds = millis;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.maxBodySizeBytes;
        }

        @Override
        public Connection.Request maxBodySize(int bytes) {
            Validate.isTrue(bytes >= 0, "maxSize must be 0 (unlimited) or larger");
            this.maxBodySizeBytes = bytes;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        @Override
        public Connection.Request followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.ignoreHttpErrors;
        }

        @Override
        public SSLSocketFactory sslSocketFactory() {
            return this.sslSocketFactory;
        }

        @Override
        public void sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        @Override
        public Connection.Request ignoreHttpErrors(boolean ignoreHttpErrors) {
            this.ignoreHttpErrors = ignoreHttpErrors;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.ignoreContentType;
        }

        @Override
        public Connection.Request ignoreContentType(boolean ignoreContentType) {
            this.ignoreContentType = ignoreContentType;
            return this;
        }

        @Override
        public Request data(Connection.KeyVal keyval) {
            Validate.notNull(keyval, "Key val must not be null");
            this.data.add(keyval);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.data;
        }

        @Override
        public Connection.Request requestBody(@Nullable String body2) {
            this.body = body2;
            return this;
        }

        @Override
        public String requestBody() {
            return this.body;
        }

        @Override
        public Request parser(Parser parser) {
            this.parser = parser;
            this.parserDefined = true;
            return this;
        }

        @Override
        public Parser parser() {
            return this.parser;
        }

        @Override
        public Connection.Request postDataCharset(String charset) {
            Validate.notNull(charset, "Charset must not be null");
            if (!Charset.isSupported(charset)) {
                throw new IllegalCharsetNameException(charset);
            }
            this.postDataCharset = charset;
            return this;
        }

        @Override
        public String postDataCharset() {
            return this.postDataCharset;
        }

        CookieManager cookieManager() {
            return this.cookieManager;
        }

        static {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        }
    }

    public static class Response
    extends Base<Connection.Response>
    implements Connection.Response {
        private static final int MAX_REDIRECTS = 20;
        private static final String LOCATION = "Location";
        private final int statusCode;
        private final String statusMessage;
        @Nullable
        private ByteBuffer byteData;
        @Nullable
        private InputStream bodyStream;
        @Nullable
        private HttpURLConnection conn;
        @Nullable
        private String charset;
        @Nullable
        private final String contentType;
        private boolean executed = false;
        private boolean inputStreamRead = false;
        private int numRedirects = 0;
        private final Request req;
        private static final Pattern xmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?xml.*");

        Response() {
            this.statusCode = 400;
            this.statusMessage = "Request not made";
            this.req = new Request();
            this.contentType = null;
        }

        static Response execute(Request req) throws IOException {
            return Response.execute(req, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Response execute(Request req, @Nullable Response previousResponse) throws IOException {
            boolean hasRequestBody;
            Request request = req;
            synchronized (request) {
                Validate.isFalse(req.executing, "Multiple threads were detected trying to execute the same request concurrently. Make sure to use Connection#newRequest() and do not share an executing request between threads.");
                req.executing = true;
            }
            Validate.notNull(req, "Request must not be null");
            URL url2 = req.url();
            Validate.notNull(url2, "URL must be specified to connect");
            String protocol = url2.getProtocol();
            if (!protocol.equals("http") && !protocol.equals("https")) {
                throw new MalformedURLException("Only http & https protocols supported");
            }
            boolean methodHasBody = req.method().hasBody();
            boolean bl = hasRequestBody = req.requestBody() != null;
            if (!methodHasBody) {
                Validate.isFalse(hasRequestBody, "Cannot set a request body for HTTP method " + (Object)((Object)req.method()));
            }
            String mimeBoundary = null;
            if (req.data().size() > 0 && (!methodHasBody || hasRequestBody)) {
                Response.serialiseRequestUrl(req);
            } else if (methodHasBody) {
                mimeBoundary = Response.setOutputContentType(req);
            }
            long startTime = System.nanoTime();
            HttpURLConnection conn = Response.createConnection(req);
            Response res = null;
            try {
                conn.connect();
                if (conn.getDoOutput()) {
                    try (OutputStream out2 = conn.getOutputStream();){
                        Response.writePost(req, out2, mimeBoundary);
                    }
                }
                int status2 = conn.getResponseCode();
                res = new Response(conn, req, previousResponse);
                if (res.hasHeader(LOCATION) && req.followRedirects()) {
                    if (status2 != 307) {
                        req.method(Connection.Method.GET);
                        req.data().clear();
                        req.requestBody(null);
                        req.removeHeader(HttpConnection.CONTENT_TYPE);
                    }
                    String location = res.header(LOCATION);
                    Validate.notNull(location);
                    if (location.startsWith("http:/") && location.charAt(6) != '/') {
                        location = location.substring(6);
                    }
                    URL redir = StringUtil.resolve(req.url(), location);
                    req.url(HttpConnection.encodeUrl(redir));
                    req.executing = false;
                    Response response = Response.execute(req, res);
                    return response;
                }
                if (!(status2 >= 200 && status2 < 400 || req.ignoreHttpErrors())) {
                    throw new HttpStatusException("HTTP error fetching URL", status2, req.url().toString());
                }
                String contentType2 = res.contentType();
                if (!(contentType2 == null || req.ignoreContentType() || contentType2.startsWith("text/") || xmlContentTypeRxp.matcher(contentType2).matches())) {
                    throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/*+xml", contentType2, req.url().toString());
                }
                if (contentType2 != null && xmlContentTypeRxp.matcher(contentType2).matches() && !req.parserDefined) {
                    req.parser(Parser.xmlParser());
                }
                res.charset = DataUtil.getCharsetFromContentType(res.contentType);
                if (conn.getContentLength() != 0 && req.method() != Connection.Method.HEAD) {
                    res.bodyStream = conn.getErrorStream() != null ? conn.getErrorStream() : conn.getInputStream();
                    Validate.notNull(res.bodyStream);
                    if (res.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "gzip")) {
                        res.bodyStream = new GZIPInputStream(res.bodyStream);
                    } else if (res.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "deflate")) {
                        res.bodyStream = new InflaterInputStream(res.bodyStream, new Inflater(true));
                    }
                    res.bodyStream = ConstrainableInputStream.wrap(res.bodyStream, 32768, req.maxBodySize()).timeout(startTime, req.timeout());
                } else {
                    res.byteData = DataUtil.emptyByteBuffer();
                }
            }
            catch (IOException e) {
                if (res != null) {
                    super.safeClose();
                }
                throw e;
            }
            finally {
                req.executing = false;
            }
            res.executed = true;
            return res;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public String statusMessage() {
            return this.statusMessage;
        }

        @Override
        public String charset() {
            return this.charset;
        }

        @Override
        public Response charset(String charset) {
            this.charset = charset;
            return this;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public Document parse() throws IOException {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            if (this.byteData != null) {
                this.bodyStream = new ByteArrayInputStream(this.byteData.array());
                this.inputStreamRead = false;
            }
            Validate.isFalse(this.inputStreamRead, "Input stream already read and parsed, cannot re-read.");
            Document doc = DataUtil.parseInputStream(this.bodyStream, this.charset, this.url.toExternalForm(), this.req.parser());
            doc.connection(new HttpConnection(this.req, this));
            this.charset = doc.outputSettings().charset().name();
            this.inputStreamRead = true;
            this.safeClose();
            return doc;
        }

        private void prepareByteData() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            if (this.bodyStream != null && this.byteData == null) {
                Validate.isFalse(this.inputStreamRead, "Request has already been read (with .parse())");
                try {
                    this.byteData = DataUtil.readToByteBuffer(this.bodyStream, this.req.maxBodySize());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    this.inputStreamRead = true;
                    this.safeClose();
                }
            }
        }

        @Override
        public String body() {
            this.prepareByteData();
            Validate.notNull(this.byteData);
            String body2 = (this.charset == null ? DataUtil.UTF_8 : Charset.forName(this.charset)).decode(this.byteData).toString();
            ((Buffer)this.byteData).rewind();
            return body2;
        }

        @Override
        public byte[] bodyAsBytes() {
            this.prepareByteData();
            Validate.notNull(this.byteData);
            return this.byteData.array();
        }

        @Override
        public Connection.Response bufferUp() {
            this.prepareByteData();
            return this;
        }

        @Override
        public BufferedInputStream bodyStream() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            Validate.isFalse(this.inputStreamRead, "Request has already been read");
            this.inputStreamRead = true;
            return ConstrainableInputStream.wrap(this.bodyStream, 32768, this.req.maxBodySize());
        }

        private static HttpURLConnection createConnection(Request req) throws IOException {
            Proxy proxy = req.proxy();
            HttpURLConnection conn = (HttpURLConnection)(proxy == null ? req.url().openConnection() : req.url().openConnection(proxy));
            conn.setRequestMethod(req.method().name());
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(req.timeout());
            conn.setReadTimeout(req.timeout() / 2);
            if (req.sslSocketFactory() != null && conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(req.sslSocketFactory());
            }
            if (req.method().hasBody()) {
                conn.setDoOutput(true);
            }
            CookieUtil.applyCookiesToRequest(req, conn);
            for (Map.Entry header2 : req.multiHeaders().entrySet()) {
                for (String value : (List)header2.getValue()) {
                    conn.addRequestProperty((String)header2.getKey(), value);
                }
            }
            return conn;
        }

        private void safeClose() {
            if (this.bodyStream != null) {
                try {
                    this.bodyStream.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.bodyStream = null;
                }
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }

        private Response(HttpURLConnection conn, Request request, @Nullable Response previousResponse) throws IOException {
            this.conn = conn;
            this.req = request;
            this.method = Connection.Method.valueOf(conn.getRequestMethod());
            this.url = conn.getURL();
            this.statusCode = conn.getResponseCode();
            this.statusMessage = conn.getResponseMessage();
            this.contentType = conn.getContentType();
            LinkedHashMap<String, List<String>> resHeaders = Response.createHeaderMap(conn);
            this.processResponseHeaders(resHeaders);
            CookieUtil.storeCookies(this.req, this.url, resHeaders);
            if (previousResponse != null) {
                for (Map.Entry prevCookie : previousResponse.cookies().entrySet()) {
                    if (this.hasCookie((String)prevCookie.getKey())) continue;
                    this.cookie((String)prevCookie.getKey(), (String)prevCookie.getValue());
                }
                previousResponse.safeClose();
                this.numRedirects = previousResponse.numRedirects + 1;
                if (this.numRedirects >= 20) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", previousResponse.url()));
                }
            }
        }

        private static LinkedHashMap<String, List<String>> createHeaderMap(HttpURLConnection conn) {
            LinkedHashMap<String, List<String>> headers2 = new LinkedHashMap<String, List<String>>();
            int i2 = 0;
            while (true) {
                String key2 = conn.getHeaderFieldKey(i2);
                String val = conn.getHeaderField(i2);
                if (key2 == null && val == null) break;
                ++i2;
                if (key2 == null || val == null) continue;
                if (headers2.containsKey(key2)) {
                    headers2.get(key2).add(val);
                    continue;
                }
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(val);
                headers2.put(key2, vals);
            }
            return headers2;
        }

        void processResponseHeaders(Map<String, List<String>> resHeaders) {
            for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
                String name = entry.getKey();
                if (name == null) continue;
                List<String> values2 = entry.getValue();
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    for (String value : values2) {
                        if (value == null) continue;
                        TokenQueue cd = new TokenQueue(value);
                        String cookieName = cd.chompTo("=").trim();
                        String cookieVal = cd.consumeTo(";").trim();
                        if (cookieName.length() <= 0 || this.cookies.containsKey(cookieName)) continue;
                        this.cookie(cookieName, cookieVal);
                    }
                }
                for (String value : values2) {
                    this.addHeader(name, value);
                }
            }
        }

        @Nullable
        private static String setOutputContentType(Connection.Request req) {
            String contentType2 = req.header(HttpConnection.CONTENT_TYPE);
            String bound = null;
            if (contentType2 != null) {
                if (contentType2.contains(HttpConnection.MULTIPART_FORM_DATA) && !contentType2.contains("boundary")) {
                    bound = DataUtil.mimeBoundary();
                    req.header(HttpConnection.CONTENT_TYPE, "multipart/form-data; boundary=" + bound);
                }
            } else if (HttpConnection.needsMultipart(req)) {
                bound = DataUtil.mimeBoundary();
                req.header(HttpConnection.CONTENT_TYPE, "multipart/form-data; boundary=" + bound);
            } else {
                req.header(HttpConnection.CONTENT_TYPE, "application/x-www-form-urlencoded; charset=" + req.postDataCharset());
            }
            return bound;
        }

        private static void writePost(Connection.Request req, OutputStream outputStream2, @Nullable String boundary) throws IOException {
            Collection<Connection.KeyVal> data2 = req.data();
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(outputStream2, req.postDataCharset()));
            if (boundary != null) {
                for (Connection.KeyVal keyVal : data2) {
                    w.write("--");
                    w.write(boundary);
                    w.write("\r\n");
                    w.write("Content-Disposition: form-data; name=\"");
                    w.write(HttpConnection.encodeMimeName(keyVal.key()));
                    w.write("\"");
                    InputStream input2 = keyVal.inputStream();
                    if (input2 != null) {
                        w.write("; filename=\"");
                        w.write(HttpConnection.encodeMimeName(keyVal.value()));
                        w.write("\"\r\nContent-Type: ");
                        String contentType2 = keyVal.contentType();
                        w.write(contentType2 != null ? contentType2 : HttpConnection.DefaultUploadType);
                        w.write("\r\n\r\n");
                        w.flush();
                        DataUtil.crossStreams(input2, outputStream2);
                        outputStream2.flush();
                    } else {
                        w.write("\r\n\r\n");
                        w.write(keyVal.value());
                    }
                    w.write("\r\n");
                }
                w.write("--");
                w.write(boundary);
                w.write("--");
            } else {
                String body2 = req.requestBody();
                if (body2 != null) {
                    w.write(body2);
                } else {
                    boolean first2 = true;
                    for (Connection.KeyVal keyVal : data2) {
                        if (!first2) {
                            w.append('&');
                        } else {
                            first2 = false;
                        }
                        w.write(URLEncoder.encode(keyVal.key(), req.postDataCharset()));
                        w.write(61);
                        w.write(URLEncoder.encode(keyVal.value(), req.postDataCharset()));
                    }
                }
            }
            w.close();
        }

        private static void serialiseRequestUrl(Connection.Request req) throws IOException {
            URL in = req.url();
            StringBuilder url2 = StringUtil.borrowBuilder();
            boolean first2 = true;
            url2.append(in.getProtocol()).append("://").append(in.getAuthority()).append(in.getPath()).append("?");
            if (in.getQuery() != null) {
                url2.append(in.getQuery());
                first2 = false;
            }
            for (Connection.KeyVal keyVal : req.data()) {
                Validate.isFalse(keyVal.hasInputStream(), "InputStream data not supported in URL query string.");
                if (!first2) {
                    url2.append('&');
                } else {
                    first2 = false;
                }
                url2.append(URLEncoder.encode(keyVal.key(), DataUtil.defaultCharsetName)).append('=').append(URLEncoder.encode(keyVal.value(), DataUtil.defaultCharsetName));
            }
            req.url(new URL(StringUtil.releaseBuilder(url2)));
            req.data().clear();
        }
    }

    public static class KeyVal
    implements Connection.KeyVal {
        private String key;
        private String value;
        @Nullable
        private InputStream stream;
        @Nullable
        private String contentType;

        public static KeyVal create(String key2, String value) {
            return new KeyVal(key2, value);
        }

        public static KeyVal create(String key2, String filename, InputStream stream) {
            return new KeyVal(key2, filename).inputStream(stream);
        }

        private KeyVal(String key2, String value) {
            Validate.notEmpty(key2, "Data key must not be empty");
            Validate.notNull(value, "Data value must not be null");
            this.key = key2;
            this.value = value;
        }

        @Override
        public KeyVal key(String key2) {
            Validate.notEmpty(key2, "Data key must not be empty");
            this.key = key2;
            return this;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public KeyVal value(String value) {
            Validate.notNull(value, "Data value must not be null");
            this.value = value;
            return this;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public KeyVal inputStream(InputStream inputStream2) {
            Validate.notNull(this.value, "Data input stream must not be null");
            this.stream = inputStream2;
            return this;
        }

        @Override
        public InputStream inputStream() {
            return this.stream;
        }

        @Override
        public boolean hasInputStream() {
            return this.stream != null;
        }

        @Override
        public Connection.KeyVal contentType(String contentType2) {
            Validate.notEmpty(contentType2);
            this.contentType = contentType2;
            return this;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static abstract class Base<T extends Connection.Base<T>>
    implements Connection.Base<T> {
        private static final URL UnsetUrl;
        URL url = UnsetUrl;
        Connection.Method method = Connection.Method.GET;
        Map<String, List<String>> headers;
        Map<String, String> cookies;

        private Base() {
            this.headers = new LinkedHashMap<String, List<String>>();
            this.cookies = new LinkedHashMap<String, String>();
        }

        private Base(Base<T> copy2) {
            this.url = copy2.url;
            this.method = copy2.method;
            this.headers = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : copy2.headers.entrySet()) {
                this.headers.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            this.cookies = new LinkedHashMap<String, String>();
            this.cookies.putAll(copy2.cookies);
        }

        @Override
        public URL url() {
            if (this.url == UnsetUrl) {
                throw new IllegalArgumentException("URL not set. Make sure to call #url(...) before executing the request.");
            }
            return this.url;
        }

        @Override
        public T url(URL url2) {
            Validate.notNull(url2, "URL must not be null");
            this.url = HttpConnection.punyUrl(url2);
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.method;
        }

        @Override
        public T method(Connection.Method method2) {
            Validate.notNull((Object)method2, "Method must not be null");
            this.method = method2;
            return (T)this;
        }

        @Override
        public String header(String name) {
            Validate.notNull(name, "Header name must not be null");
            List<String> vals = this.getHeadersCaseInsensitive(name);
            if (vals.size() > 0) {
                return StringUtil.join(vals, ", ");
            }
            return null;
        }

        @Override
        public T addHeader(String name, String value) {
            Validate.notEmpty(name);
            value = value == null ? "" : value;
            List<String> values2 = this.headers(name);
            if (values2.isEmpty()) {
                values2 = new ArrayList<String>();
                this.headers.put(name, values2);
            }
            values2.add(Base.fixHeaderEncoding(value));
            return (T)this;
        }

        @Override
        public List<String> headers(String name) {
            Validate.notEmpty(name);
            return this.getHeadersCaseInsensitive(name);
        }

        private static String fixHeaderEncoding(String val) {
            byte[] bytes = val.getBytes(ISO_8859_1);
            if (!Base.looksLikeUtf8(bytes)) {
                return val;
            }
            return new String(bytes, UTF_8);
        }

        private static boolean looksLikeUtf8(byte[] input2) {
            int i2 = 0;
            if (input2.length >= 3 && (input2[0] & 0xFF) == 239 && (input2[1] & 0xFF) == 187 && (input2[2] & 0xFF) == 191) {
                i2 = 3;
            }
            int j = input2.length;
            while (i2 < j) {
                byte o = input2[i2];
                if ((o & 0x80) != 0) {
                    int end2;
                    if ((o & 0xE0) == 192) {
                        end2 = i2 + 1;
                    } else if ((o & 0xF0) == 224) {
                        end2 = i2 + 2;
                    } else if ((o & 0xF8) == 240) {
                        end2 = i2 + 3;
                    } else {
                        return false;
                    }
                    if (end2 >= input2.length) {
                        return false;
                    }
                    while (i2 < end2) {
                        if (((o = input2[++i2]) & 0xC0) == 128) continue;
                        return false;
                    }
                }
                ++i2;
            }
            return true;
        }

        @Override
        public T header(String name, String value) {
            Validate.notEmpty(name, "Header name must not be empty");
            this.removeHeader(name);
            this.addHeader(name, value);
            return (T)this;
        }

        @Override
        public boolean hasHeader(String name) {
            Validate.notEmpty(name, "Header name must not be empty");
            return !this.getHeadersCaseInsensitive(name).isEmpty();
        }

        @Override
        public boolean hasHeaderWithValue(String name, String value) {
            Validate.notEmpty(name);
            Validate.notEmpty(value);
            List<String> values2 = this.headers(name);
            for (String candidate : values2) {
                if (!value.equalsIgnoreCase(candidate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public T removeHeader(String name) {
            Validate.notEmpty(name, "Header name must not be empty");
            Map.Entry<String, List<String>> entry = this.scanHeaders(name);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
            return (T)this;
        }

        @Override
        public Map<String, String> headers() {
            LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>(this.headers.size());
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                String header2 = entry.getKey();
                List<String> values2 = entry.getValue();
                if (values2.size() <= 0) continue;
                map2.put(header2, values2.get(0));
            }
            return map2;
        }

        @Override
        public Map<String, List<String>> multiHeaders() {
            return this.headers;
        }

        private List<String> getHeadersCaseInsensitive(String name) {
            Validate.notNull(name);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                if (!name.equalsIgnoreCase(entry.getKey())) continue;
                return entry.getValue();
            }
            return Collections.emptyList();
        }

        @Nullable
        private Map.Entry<String, List<String>> scanHeaders(String name) {
            String lc = Normalizer.lowerCase(name);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                if (!Normalizer.lowerCase(entry.getKey()).equals(lc)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public String cookie(String name) {
            Validate.notEmpty(name, "Cookie name must not be empty");
            return this.cookies.get(name);
        }

        @Override
        public T cookie(String name, String value) {
            Validate.notEmpty(name, "Cookie name must not be empty");
            Validate.notNull(value, "Cookie value must not be null");
            this.cookies.put(name, value);
            return (T)this;
        }

        @Override
        public boolean hasCookie(String name) {
            Validate.notEmpty(name, "Cookie name must not be empty");
            return this.cookies.containsKey(name);
        }

        @Override
        public T removeCookie(String name) {
            Validate.notEmpty(name, "Cookie name must not be empty");
            this.cookies.remove(name);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.cookies;
        }

        static {
            try {
                UnsetUrl = new URL("http://undefined/");
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

