/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import kotlinx.css.FlexBasis;
import kotlinx.css.LinearDimension;
import kotlinx.css.QuotedString;
import kotlinx.css.VerticalAlign;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017\u001a&\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017\u001a&\u0010!\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010#\u001a\u00020\u000b*\u00020\u000bH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006$"}, d2={"basis", "Lkotlinx/css/FlexBasis;", "Lkotlinx/css/LinearDimension;", "getBasis", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/FlexBasis;", "down", "Lkotlinx/css/VerticalAlign;", "getDown", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/VerticalAlign;", "quoted", "Lkotlinx/css/QuotedString;", "", "getQuoted", "(Ljava/lang/String;)Lkotlinx/css/QuotedString;", "up", "getUp", "blackAlpha", "Lkotlinx/css/Color;", "alpha", "", "formatAlpha", "hex", "value", "", "hsl", "hue", "saturation", "lightness", "hsla", "rgb", "red", "green", "blue", "rgba", "whiteAlpha", "withZeros", "kotlin-css"})
public final class StyleEnumsKt {
    private static final String withZeros(String $this$withZeros) {
        return Intrinsics.stringPlus($this$withZeros, StringsKt.repeat("0", Math.max(0, 3 - $this$withZeros.length())));
    }

    @NotNull
    public static final Color hex(int value) {
        String string = Integer.toString(value, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
        return new Color(Intrinsics.stringPlus("#", StyleEnumsKt.withZeros(string)));
    }

    @NotNull
    public static final Color rgb(int red, int green, int blue) {
        return new Color("rgb(" + red + ", " + green + ", " + blue + ')');
    }

    @NotNull
    public static final Color rgba(int red, int green, int blue, double alpha) {
        return new Color("rgba(" + red + ", " + green + ", " + blue + ", " + StyleEnumsKt.formatAlpha(alpha) + ')');
    }

    @NotNull
    public static final Color hsl(int hue, int saturation, int lightness) {
        return new Color("hsl(" + hue + ", " + saturation + "%, " + lightness + "%)");
    }

    @NotNull
    public static final Color hsla(int hue, int saturation, int lightness, double alpha) {
        return new Color("hsla(" + hue + ", " + saturation + "%, " + lightness + "%, " + StyleEnumsKt.formatAlpha(alpha) + ')');
    }

    @NotNull
    public static final Color blackAlpha(double alpha) {
        return Color.Companion.getBlack().withAlpha(alpha);
    }

    @NotNull
    public static final Color whiteAlpha(double alpha) {
        return Color.Companion.getWhite().withAlpha(alpha);
    }

    private static final String formatAlpha(double alpha) {
        String it = String.valueOf(alpha);
        boolean bl = false;
        return StringsKt.contains$default((CharSequence)it, ".", false, 2, null) ? it : Intrinsics.stringPlus(it, ".0");
    }

    @NotNull
    public static final QuotedString getQuoted(@NotNull String $this$quoted) {
        Intrinsics.checkNotNullParameter($this$quoted, "<this>");
        return new QuotedString($this$quoted);
    }

    @NotNull
    public static final FlexBasis getBasis(@NotNull LinearDimension $this$basis) {
        Intrinsics.checkNotNullParameter($this$basis, "<this>");
        return new FlexBasis($this$basis.toString());
    }

    @NotNull
    public static final VerticalAlign getUp(@NotNull LinearDimension $this$up) {
        Intrinsics.checkNotNullParameter($this$up, "<this>");
        return new VerticalAlign($this$up.toString());
    }

    @NotNull
    public static final VerticalAlign getDown(@NotNull LinearDimension $this$down) {
        Intrinsics.checkNotNullParameter($this$down, "<this>");
        return new VerticalAlign($this$down.unaryMinus().toString());
    }
}

