/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.css.CssValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\t\u0010\u0014\u001a\u00020\u0000H\u0086\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lkotlinx/css/LinearDimension;", "Lkotlinx/css/CssValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "valueCalcSafe", "getValueCalcSafe", "div", "times", "", "equals", "", "other", "", "hashCode", "", "minus", "plus", "unaryMinus", "Companion", "kotlin-css"})
public final class LinearDimension
extends CssValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private static final LinearDimension none = new LinearDimension("none");
    @NotNull
    private static final LinearDimension auto = new LinearDimension("auto");
    @NotNull
    private static final LinearDimension initial = new LinearDimension("initial");
    @NotNull
    private static final LinearDimension inherit = new LinearDimension("inherit");
    @NotNull
    private static final LinearDimension available = new LinearDimension("available");
    @NotNull
    private static final LinearDimension fillAvailable = new LinearDimension("fill-available");
    @NotNull
    private static final LinearDimension borderBox = new LinearDimension("border-box");
    @NotNull
    private static final LinearDimension contentBox = new LinearDimension("content-box");
    @NotNull
    private static final LinearDimension maxContent = new LinearDimension("max-content");
    @NotNull
    private static final LinearDimension minContent = new LinearDimension("min-content");
    @NotNull
    private static final LinearDimension fitContent = new LinearDimension("fit-content");

    public LinearDimension(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        super(value);
        this.value = value;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    private final String getValueCalcSafe() {
        return Intrinsics.areEqual(this.getValue(), "0") ? "0px" : this.getValue();
    }

    @NotNull
    public final LinearDimension unaryMinus() {
        String string;
        if (StringsKt.startsWith$default((CharSequence)this.getValue(), '-', false, 2, null)) {
            String string2 = this.getValue().substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            string = string2;
        } else {
            string = StringsKt.startsWith$default(this.getValue(), "calc", false, 2, null) ? "calc(0px - " + this.getValue() + ')' : (Intrinsics.areEqual(this.getValue(), "0") ? this.getValue() : Intrinsics.stringPlus("-", this.getValue()));
        }
        return new LinearDimension(string);
    }

    @NotNull
    public final LinearDimension plus(@NotNull LinearDimension other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " + " + other.getValueCalcSafe() + ')');
    }

    @NotNull
    public final LinearDimension minus(@NotNull LinearDimension other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " - " + other.getValueCalcSafe() + ')');
    }

    @NotNull
    public final LinearDimension times(@NotNull Number times) {
        Intrinsics.checkNotNullParameter(times, "times");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " * " + times + ')');
    }

    @NotNull
    public final LinearDimension div(@NotNull Number times) {
        Intrinsics.checkNotNullParameter(times, "times");
        return new LinearDimension("calc(" + this.getValueCalcSafe() + " / " + times + ')');
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        LinearDimension cfr_ignored_0 = (LinearDimension)other;
        return Intrinsics.areEqual(this.getValue(), ((LinearDimension)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkotlinx/css/LinearDimension$Companion;", "", "()V", "auto", "Lkotlinx/css/LinearDimension;", "getAuto", "()Lkotlinx/css/LinearDimension;", "available", "getAvailable", "borderBox", "getBorderBox", "contentBox", "getContentBox", "fillAvailable", "getFillAvailable", "fitContent", "getFitContent", "inherit", "getInherit", "initial", "getInitial", "maxContent", "getMaxContent", "minContent", "getMinContent", "none", "getNone", "kotlin-css"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinearDimension getNone() {
            return none;
        }

        @NotNull
        public final LinearDimension getAuto() {
            return auto;
        }

        @NotNull
        public final LinearDimension getInitial() {
            return initial;
        }

        @NotNull
        public final LinearDimension getInherit() {
            return inherit;
        }

        @NotNull
        public final LinearDimension getAvailable() {
            return available;
        }

        @NotNull
        public final LinearDimension getFillAvailable() {
            return fillAvailable;
        }

        @NotNull
        public final LinearDimension getBorderBox() {
            return borderBox;
        }

        @NotNull
        public final LinearDimension getContentBox() {
            return contentBox;
        }

        @NotNull
        public final LinearDimension getMaxContent() {
            return maxContent;
        }

        @NotNull
        public final LinearDimension getMinContent() {
            return minContent;
        }

        @NotNull
        public final LinearDimension getFitContent() {
            return fitContent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

