/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.pipeline;

import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.pipeline.InvalidPhaseException;
import io.ktor.util.pipeline.PhaseContent;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelineContextKt;
import io.ktor.util.pipeline.PipelinePhase;
import io.ktor.util.pipeline.PipelinePhaseRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010!\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001BU\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012?\u0010\f\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eB\u001b\u0012\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015JQ\u0010\u0017\u001aD\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00160\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J3\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010#\u001a\u00020\"2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b#\u0010$J%\u0010&\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010%2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010.\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b.\u0010/J\u001d\u00100\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b0\u0010/J\u001f\u00103\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b3\u00104JS\u00106\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000429\u00105\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107JQ\u00108\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109JQ\u0010;\u001aD\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00160\u0006H\u0000\u00a2\u0006\u0004\b:\u0010\u0018J!\u0010<\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b<\u0010=J#\u0010>\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b>\u0010=J!\u0010?\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b?\u0010=JY\u0010A\u001a\u00020\n2H\u0010@\u001aD\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00160\u0006H\u0002\u00a2\u0006\u0004\bA\u0010BJY\u0010D\u001aD\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00160\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\bC\u00109J!\u0010E\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\bE\u0010=J\u000f\u0010F\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bF\u0010\u0015J#\u0010H\u001a\u00020\n2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\bH\u0010=J#\u0010J\u001a\u00020\n2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0002\u00a2\u0006\u0004\bJ\u0010KJQ\u0010L\u001aD\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00160\u0006H\u0002\u00a2\u0006\u0004\bL\u0010\u0018J[\u0010M\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00042B\u00105\u001a>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0016H\u0002\u00a2\u0006\u0004\bM\u0010NR\u0017\u0010P\u001a\u00020O8\u0006\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020\"8\u0016X\u0096D\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010WR\u00ac\u0001\u0010\f\u001aF\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0016\u0018\u00010\u00062J\u0010X\u001aF\u0012@\u0012>\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0016\u0018\u00010\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010\u0018\"\u0004\bZ\u0010BR\u0016\u0010[\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010UR\u0018\u0010\\\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0011\u0010`\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b`\u0010WR\u0017\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068F\u00a2\u0006\u0006\u001a\u0004\ba\u0010\u0018R\u001a\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00010c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bd\u0010e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006f"}, d2={"Lio/ktor/util/pipeline/Pipeline;", "", "TSubject", "TContext", "Lio/ktor/util/pipeline/PipelinePhase;", "phase", "", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "interceptors", "<init>", "(Lio/ktor/util/pipeline/PipelinePhase;Ljava/util/List;)V", "", "phases", "([Lio/ktor/util/pipeline/PipelinePhase;)V", "addPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "afterIntercepted", "()V", "Lio/ktor/util/pipeline/PipelineInterceptorFunction;", "cacheInterceptors", "()Ljava/util/List;", "context", "subject", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "createContext", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/CoroutineContext;)Lio/ktor/util/pipeline/PipelineContext;", "execute", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "from", "", "fastPathMerge", "(Lio/ktor/util/pipeline/Pipeline;)Z", "Lio/ktor/util/pipeline/PhaseContent;", "findPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Lio/ktor/util/pipeline/PhaseContent;", "", "findPhaseIndex", "(Lio/ktor/util/pipeline/PipelinePhase;)I", "hasPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Z", "reference", "insertPhaseAfter", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/PipelinePhase;)V", "insertPhaseBefore", "fromPhaseOrContent", "fromPhase", "insertRelativePhase", "(Ljava/lang/Object;Lio/ktor/util/pipeline/PipelinePhase;)Z", "block", "intercept", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)V", "interceptorsForPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Ljava/util/List;", "interceptorsForTests$ktor_utils", "interceptorsForTests", "merge", "(Lio/ktor/util/pipeline/Pipeline;)V", "mergeInterceptors", "mergePhases", "list", "notSharedInterceptorsList", "(Ljava/util/List;)V", "phaseInterceptors$ktor_utils", "phaseInterceptors", "resetFrom", "resetInterceptorsList", "pipeline", "setInterceptorsListFromAnotherPipeline", "phaseContent", "setInterceptorsListFromPhase", "(Lio/ktor/util/pipeline/PhaseContent;)V", "sharedInterceptorsList", "tryAddToPhaseFastPath", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)Z", "Lio/ktor/util/Attributes;", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "developmentMode", "Z", "getDevelopmentMode", "()Z", "value", "getInterceptors", "setInterceptors", "interceptorsListShared", "interceptorsListSharedPhase", "Lio/ktor/util/pipeline/PipelinePhase;", "interceptorsQuantity", "I", "isEmpty", "getItems", "items", "", "phasesRaw", "Ljava/util/List;", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1549#2:504\n1620#2,3:505\n1855#2,2:508\n800#2,11:510\n288#2,2:521\n1855#2,2:523\n*S KotlinDebug\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n*L\n43#1:504\n43#1:505,3\n70#1:508,2\n173#1:510,11\n174#1:521,2\n214#1:523,2\n*E\n"})
public class Pipeline<TSubject, TContext> {
    @NotNull
    private final Attributes attributes;
    private final boolean developmentMode;
    @NotNull
    private final List<Object> phasesRaw;
    private int interceptorsQuantity;
    @NotNull
    private volatile /* synthetic */ Object _interceptors;
    private boolean interceptorsListShared;
    @Nullable
    private PipelinePhase interceptorsListSharedPhase;

    public Pipeline(PipelinePhase ... phases) {
        Intrinsics.checkNotNullParameter(phases, "phases");
        this.attributes = AttributesJvmKt.Attributes(true);
        this.phasesRaw = CollectionsKt.mutableListOf(Arrays.copyOf(phases, phases.length));
        this._interceptors = null;
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PipelinePhase> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.phasesRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PipelinePhase pipelinePhase = it instanceof PipelinePhase ? (PipelinePhase)it : null;
            if (pipelinePhase == null) {
                PhaseContent phaseContent = it instanceof PhaseContent ? (PhaseContent)it : null;
                PipelinePhase pipelinePhase2 = phaseContent != null ? phaseContent.getPhase() : null;
                pipelinePhase = pipelinePhase2;
                Intrinsics.checkNotNull(pipelinePhase2);
            }
            collection.add(pipelinePhase);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isEmpty() {
        return this.interceptorsQuantity == 0;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> getInterceptors() {
        return (List)this._interceptors;
    }

    private final void setInterceptors(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> value) {
        this._interceptors = value;
    }

    public Pipeline(@NotNull PipelinePhase phase, @NotNull List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        PipelinePhase[] pipelinePhaseArray = new PipelinePhase[]{phase};
        this(pipelinePhaseArray);
        Iterable $this$forEach$iv = interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3 it = (Function3)element$iv;
            boolean bl = false;
            this.intercept(phase, it);
        }
    }

    @Nullable
    public final Object execute(@NotNull TContext context, @NotNull TSubject subject, @NotNull Continuation<? super TSubject> $completion) {
        return this.createContext(context, subject, $completion.getContext()).execute$ktor_utils(subject, $completion);
    }

    public final void addPhase(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        this.phasesRaw.add(phase);
    }

    public final void insertPhaseAfter(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        int lastRelatedPhaseIndex = index;
        int i2 = index + 1;
        int n = CollectionsKt.getLastIndex(this.phasesRaw);
        if (i2 <= n) {
            Object object;
            Object object2;
            while ((object2 = (object = this.phasesRaw.get(i2)) instanceof PhaseContent ? (PhaseContent)object : null) != null && (object2 = ((PhaseContent)object2).getRelation()) != null) {
                Object relation = object2;
                Object object3 = relation instanceof PipelinePhaseRelation.After ? (PipelinePhaseRelation.After)relation : null;
                if (object3 != null && (object3 = ((PipelinePhaseRelation.After)object3).getRelativeTo()) != null) {
                    Object relatedTo = object3;
                    int n2 = lastRelatedPhaseIndex = Intrinsics.areEqual(relatedTo, reference) ? i2 : lastRelatedPhaseIndex;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        this.phasesRaw.add(lastRelatedPhaseIndex + 1, new PhaseContent(phase, new PipelinePhaseRelation.After(reference)));
    }

    public final void insertPhaseBefore(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add(index, new PhaseContent(phase, new PipelinePhaseRelation.Before(reference)));
    }

    public final void intercept(@NotNull PipelinePhase phase, @NotNull Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block2) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Intrinsics.checkNotNullParameter(block2, "block");
        PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
        if (phaseContent == null) {
            throw new InvalidPhaseException("Phase " + phase + " was not registered for this pipeline");
        }
        PhaseContent<? super TSubject, TContext> phaseContent2 = phaseContent;
        Function3 cfr_ignored_0 = (Function3)TypeIntrinsics.beforeCheckcastToFunctionOfArity(block2, 3);
        if (this.tryAddToPhaseFastPath(phase, block2)) {
            int n = this.interceptorsQuantity;
            this.interceptorsQuantity = n + 1;
            return;
        }
        phaseContent2.addInterceptor(block2);
        int n = this.interceptorsQuantity;
        this.interceptorsQuantity = n + 1;
        this.resetInterceptorsList();
        this.afterIntercepted();
    }

    public void afterIntercepted() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForPhase(@NotNull PipelinePhase phase) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(phase, "phase");
            Iterable $this$filterIsInstance$iv = this.phasesRaw;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PhaseContent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PhaseContent phaseOrContent = (PhaseContent)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(phaseOrContent.getPhase(), phase)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PhaseContent phaseContent = v0;
        List<Function3<PipelineContext<TSubject, TContext>, Object, Continuation<Unit>, Object>> list = phaseContent != null ? phaseContent.sharedInterceptors() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void mergePhases(@NotNull Pipeline<TSubject, TContext> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        List<Object> fromPhases = from.phasesRaw;
        List toInsert = CollectionsKt.toMutableList((Collection)fromPhases);
        while (!((Collection)toInsert).isEmpty()) {
            Iterator iterator2 = toInsert.iterator();
            while (iterator2.hasNext()) {
                PipelinePhase fromPhase;
                Object fromPhaseOrContent = iterator2.next();
                PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
                if (pipelinePhase == null) {
                    Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                    pipelinePhase = ((PhaseContent)fromPhaseOrContent).getPhase();
                }
                if (this.hasPhase(fromPhase = pipelinePhase)) {
                    iterator2.remove();
                    continue;
                }
                boolean inserted = this.insertRelativePhase(fromPhaseOrContent, fromPhase);
                if (!inserted) continue;
                iterator2.remove();
            }
        }
    }

    private final void mergeInterceptors(Pipeline<TSubject, TContext> from) {
        if (this.interceptorsQuantity == 0) {
            this.setInterceptorsListFromAnotherPipeline(from);
        } else {
            this.resetInterceptorsList();
        }
        List<Object> fromPhases = from.phasesRaw;
        Iterable $this$forEach$iv = fromPhases;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PipelinePhase fromPhase;
            Object element$iv;
            Object fromPhaseOrContent = element$iv = iterator2.next();
            boolean bl = false;
            PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
            if (pipelinePhase == null) {
                Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                pipelinePhase = fromPhase = ((PhaseContent)fromPhaseOrContent).getPhase();
            }
            if (!(fromPhaseOrContent instanceof PhaseContent) || ((PhaseContent)fromPhaseOrContent).isEmpty()) continue;
            PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
            PhaseContent phaseContent = (PhaseContent)fromPhaseOrContent;
            PhaseContent<TSubject, TContext> phaseContent2 = this.findPhase(fromPhase);
            Intrinsics.checkNotNull(phaseContent2);
            phaseContent.addTo(phaseContent2);
            this.interceptorsQuantity += ((PhaseContent)fromPhaseOrContent).getSize();
        }
    }

    public final void merge(@NotNull Pipeline<TSubject, TContext> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        if (this.fastPathMerge(from)) {
            return;
        }
        this.mergePhases(from);
        this.mergeInterceptors(from);
    }

    public final void resetFrom(@NotNull Pipeline<TSubject, TContext> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.phasesRaw.clear();
        if (!(this.interceptorsQuantity == 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.fastPathMerge(from);
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> phaseInterceptors$ktor_utils(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Object object = this.findPhase(phase);
        if (object == null || (object = ((PhaseContent)object).sharedInterceptors()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForTests$ktor_utils() {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list = this.getInterceptors();
        if (list == null) {
            list = this.cacheInterceptors();
        }
        return list;
    }

    private final PipelineContext<TSubject, TContext> createContext(TContext context, TSubject subject, CoroutineContext coroutineContext) {
        return PipelineContextKt.pipelineContextFor(context, this.sharedInterceptorsList(), subject, coroutineContext, this.getDevelopmentMode());
    }

    private final PhaseContent<TSubject, TContext> findPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            Object current = phasesList.get(index);
            if (current == phase) {
                PhaseContent content2 = new PhaseContent(phase, PipelinePhaseRelation.Last.INSTANCE);
                phasesList.set(index, content2);
                return content2;
            }
            if (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase) continue;
            return (PhaseContent)current;
        }
        return null;
    }

    private final int findPhaseIndex(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            Object current = phasesList.get(index);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return index;
        }
        return -1;
    }

    private final boolean hasPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index = 0; index < n; ++index) {
            Object current = phasesList.get(index);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return true;
        }
        return false;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> cacheInterceptors() {
        int n;
        int phaseIndex;
        int interceptorsQuantity = this.interceptorsQuantity;
        if (interceptorsQuantity == 0) {
            this.notSharedInterceptorsList(CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Object> phases = this.phasesRaw;
        if (interceptorsQuantity == 1 && (phaseIndex = 0) <= (n = CollectionsKt.getLastIndex(phases))) {
            while (true) {
                PhaseContent phaseContent;
                Object object;
                PhaseContent phaseContent2 = (object = phases.get(phaseIndex)) instanceof PhaseContent ? (PhaseContent)object : null;
                if (phaseContent2 != null && !(phaseContent = phaseContent2).isEmpty()) {
                    List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptors = phaseContent.sharedInterceptors();
                    this.setInterceptorsListFromPhase(phaseContent);
                    return interceptors;
                }
                if (phaseIndex == n) break;
                ++phaseIndex;
            }
        }
        List destination = new ArrayList();
        int phaseIndex2 = 0;
        int n2 = CollectionsKt.getLastIndex(phases);
        if (phaseIndex2 <= n2) {
            while (true) {
                Object object;
                if (((object = phases.get(phaseIndex2)) instanceof PhaseContent ? (PhaseContent)object : null) != null) {
                    PhaseContent phase;
                    phase = phase;
                    phase.addTo(destination);
                }
                if (phaseIndex2 == n2) break;
                ++phaseIndex2;
            }
        }
        this.notSharedInterceptorsList(destination);
        return destination;
    }

    private final boolean fastPathMerge(Pipeline<TSubject, TContext> from) {
        if (from.phasesRaw.isEmpty()) {
            return true;
        }
        if (!((Collection)this.phasesRaw).isEmpty()) {
            return false;
        }
        int index = 0;
        List<Object> fromPhases = from.phasesRaw;
        int n = CollectionsKt.getLastIndex(fromPhases);
        if (index <= n) {
            while (true) {
                Object fromPhaseOrContent;
                if ((fromPhaseOrContent = fromPhases.get(index)) instanceof PipelinePhase) {
                    this.phasesRaw.add(fromPhaseOrContent);
                } else if (fromPhaseOrContent instanceof PhaseContent) {
                    PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                    this.phasesRaw.add(new PhaseContent(((PhaseContent)fromPhaseOrContent).getPhase(), ((PhaseContent)fromPhaseOrContent).getRelation(), ((PhaseContent)fromPhaseOrContent).sharedInterceptors()));
                }
                if (index == n) break;
                ++index;
            }
        }
        this.interceptorsQuantity += from.interceptorsQuantity;
        this.setInterceptorsListFromAnotherPipeline(from);
        return true;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptorsList() {
        if (this.getInterceptors() == null) {
            this.cacheInterceptors();
        }
        this.interceptorsListShared = true;
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> list = this.getInterceptors();
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void resetInterceptorsList() {
        this.setInterceptors(null);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void notSharedInterceptorsList(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list) {
        this.setInterceptors(list);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void setInterceptorsListFromPhase(PhaseContent<TSubject, TContext> phaseContent) {
        this.setInterceptors(phaseContent.sharedInterceptors());
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = phaseContent.getPhase();
    }

    private final void setInterceptorsListFromAnotherPipeline(Pipeline<TSubject, TContext> pipeline) {
        this.setInterceptors(super.sharedInterceptorsList());
        this.interceptorsListShared = true;
        this.interceptorsListSharedPhase = null;
    }

    private final boolean tryAddToPhaseFastPath(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block2) {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> currentInterceptors = this.getInterceptors();
        if (this.phasesRaw.isEmpty() || currentInterceptors == null) {
            return false;
        }
        if (this.interceptorsListShared || !TypeIntrinsics.isMutableList(currentInterceptors)) {
            return false;
        }
        if (Intrinsics.areEqual(this.interceptorsListSharedPhase, phase)) {
            currentInterceptors.add(block2);
            return true;
        }
        if (Intrinsics.areEqual(phase, CollectionsKt.last(this.phasesRaw)) || this.findPhaseIndex(phase) == CollectionsKt.getLastIndex(this.phasesRaw)) {
            PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
            Intrinsics.checkNotNull(phaseContent);
            phaseContent.addInterceptor(block2);
            currentInterceptors.add(block2);
            return true;
        }
        return false;
    }

    private final boolean insertRelativePhase(Object fromPhaseOrContent, PipelinePhase fromPhase) {
        PipelinePhaseRelation pipelinePhaseRelation;
        if (fromPhaseOrContent == fromPhase) {
            pipelinePhaseRelation = PipelinePhaseRelation.Last.INSTANCE;
        } else {
            Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
            pipelinePhaseRelation = ((PhaseContent)fromPhaseOrContent).getRelation();
        }
        PipelinePhaseRelation fromPhaseRelation = pipelinePhaseRelation;
        if (fromPhaseRelation instanceof PipelinePhaseRelation.Last) {
            this.addPhase(fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.Before && this.hasPhase(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo())) {
            this.insertPhaseBefore(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.After) {
            this.insertPhaseAfter(((PipelinePhaseRelation.After)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else {
            return false;
        }
        return true;
    }
}

