/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.DirectoryStorageKt;
import io.ktor.server.sessions.SessionStorage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J!\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lio/ktor/server/sessions/DirectoryStorage;", "Lio/ktor/server/sessions/SessionStorage;", "Ljava/io/Closeable;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "close", "", "fileOf", "id", "", "invalidate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "requireId", "split", "Lkotlin/sequences/Sequence;", "write", "value", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nDirectoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryStorage.kt\nio/ktor/server/sessions/DirectoryStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class DirectoryStorage
implements SessionStorage,
Closeable {
    @NotNull
    private final File dir;

    public DirectoryStorage(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        this.dir = dir;
        DirectoryStorageKt.access$mkdirsOrFail(this.dir);
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public Object write(@NotNull String id, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        File file2 = this.fileOf(id);
        File file3 = file2.getParentFile();
        if (file3 != null) {
            DirectoryStorageKt.access$mkdirsOrFail(file3);
        }
        FilesKt.writeText$default(file2, value, null, 2, null);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object read(@NotNull String id, @NotNull Continuation<? super String> $completion) {
        this.requireId(id);
        try {
            String string;
            File file2 = this.fileOf(id);
            File file3 = file2.getParentFile();
            if (file3 != null) {
                DirectoryStorageKt.access$mkdirsOrFail(file3);
            }
            String it = string = FilesKt.readText$default(file2, null, 1, null);
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) {
                throw new IllegalStateException("Failed to read stored session from " + file2);
            }
            return string2;
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
    }

    @Override
    @Nullable
    public Object invalidate(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        try {
            File file2 = this.fileOf(id);
            file2.delete();
            File file3 = file2.getParentFile();
            if (file3 != null) {
                DirectoryStorageKt.access$deleteParentsWhileEmpty(file3, this.dir);
            }
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
        return Unit.INSTANCE;
    }

    private final File fileOf(String id) {
        Sequence<String> sequence = this.split(id);
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue(string, "separator");
        return new File(this.dir, SequencesKt.joinToString$default(sequence, string, null, ".dat", 0, null, null, 58, null));
    }

    private final Sequence<String> split(String id) {
        return StringsKt.windowedSequence(id, 2, 2, true);
    }

    private final void requireId(String id) {
        if (((CharSequence)id).length() == 0) {
            throw new IllegalArgumentException("Session id is empty");
        }
        String[] stringArray = new String[]{"..", "/", "\\", "!", "?", ">", "<", "\u0000"};
        if (StringsKt.indexOfAny$default((CharSequence)id, CollectionsKt.listOf(stringArray), 0, false, 6, null) != -1) {
            throw new IllegalArgumentException("Bad session id " + id);
        }
    }
}

