/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.forwardedheaders;

import io.ktor.http.HttpHeaders;
import io.ktor.http.URLProtocol;
import io.ktor.server.plugins.MutableOriginConnectionPoint;
import io.ktor.server.plugins.forwardedheaders.UtilsKt;
import io.ktor.server.plugins.forwardedheaders.XForwardedHeaderValues;
import io.ktor.server.plugins.forwardedheaders.XForwardedHeadersConfig;
import io.ktor.util.KtorDsl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorDsl
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u001c\u001a\u00020\u00172\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014J4\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00162\u001a\u0010!\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050#\u0012\u0006\u0012\u0004\u0018\u00010\u00050\"H\u0002J\u0014\u0010$\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050#J\u000e\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020,*\u0004\u0018\u00010\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R,\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lio/ktor/server/plugins/forwardedheaders/XForwardedHeadersConfig;", "", "()V", "forHeaders", "", "", "getForHeaders", "()Ljava/util/List;", "hostHeaders", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getHostHeaders", "()Ljava/util/ArrayList;", "httpsFlagHeaders", "getHttpsFlagHeaders", "portHeaders", "getPortHeaders", "protoHeaders", "getProtoHeaders", "xForwardedHeadersHandler", "Lkotlin/Function2;", "Lio/ktor/server/plugins/MutableOriginConnectionPoint;", "Lio/ktor/server/plugins/forwardedheaders/XForwardedHeaderValues;", "", "getXForwardedHeadersHandler$ktor_server_forwarded_header", "()Lkotlin/jvm/functions/Function2;", "setXForwardedHeadersHandler$ktor_server_forwarded_header", "(Lkotlin/jvm/functions/Function2;)V", "extractEdgeProxy", "block", "setValues", "connectionPoint", "headers", "extractValue", "Lkotlin/Function1;", "", "skipKnownProxies", "hosts", "skipLastProxies", "proxiesCount", "", "useFirstProxy", "useLastProxy", "toBoolean", "", "ktor-server-forwarded-header"})
public final class XForwardedHeadersConfig {
    @NotNull
    private final ArrayList<String> hostHeaders;
    @NotNull
    private final List<String> protoHeaders;
    @NotNull
    private final List<String> forHeaders;
    @NotNull
    private final List<String> httpsFlagHeaders;
    @NotNull
    private final List<String> portHeaders;
    @NotNull
    private Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit> xForwardedHeadersHandler;

    public XForwardedHeadersConfig() {
        String[] stringArray = new String[]{HttpHeaders.INSTANCE.getXForwardedHost(), HttpHeaders.INSTANCE.getXForwardedServer()};
        this.hostHeaders = CollectionsKt.arrayListOf(stringArray);
        stringArray = new String[]{HttpHeaders.INSTANCE.getXForwardedProto(), "X-Forwarded-Protocol"};
        this.protoHeaders = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{HttpHeaders.INSTANCE.getXForwardedFor()};
        this.forHeaders = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{"X-Forwarded-SSL", "Front-End-Https"};
        this.httpsFlagHeaders = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{"X-Forwarded-Port"};
        this.portHeaders = CollectionsKt.mutableListOf(stringArray);
        this.xForwardedHeadersHandler = xForwardedHeadersHandler.1.INSTANCE;
        this.useFirstProxy();
    }

    @NotNull
    public final ArrayList<String> getHostHeaders() {
        return this.hostHeaders;
    }

    @NotNull
    public final List<String> getProtoHeaders() {
        return this.protoHeaders;
    }

    @NotNull
    public final List<String> getForHeaders() {
        return this.forHeaders;
    }

    @NotNull
    public final List<String> getHttpsFlagHeaders() {
        return this.httpsFlagHeaders;
    }

    @NotNull
    public final List<String> getPortHeaders() {
        return this.portHeaders;
    }

    @NotNull
    public final Function2<MutableOriginConnectionPoint, XForwardedHeaderValues, Unit> getXForwardedHeadersHandler$ktor_server_forwarded_header() {
        return this.xForwardedHeadersHandler;
    }

    public final void setXForwardedHeadersHandler$ktor_server_forwarded_header(@NotNull Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, "<set-?>");
        this.xForwardedHeadersHandler = function2;
    }

    public final void extractEdgeProxy(@NotNull Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        this.xForwardedHeadersHandler = block2;
    }

    public final void useFirstProxy() {
        this.extractEdgeProxy((Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit>)new Function2<MutableOriginConnectionPoint, XForwardedHeaderValues, Unit>(this){
            final /* synthetic */ XForwardedHeadersConfig this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull XForwardedHeaderValues headers2) {
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                XForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, headers2, useFirstProxy.1.INSTANCE);
            }
        });
    }

    public final void useLastProxy() {
        this.extractEdgeProxy((Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit>)new Function2<MutableOriginConnectionPoint, XForwardedHeaderValues, Unit>(this){
            final /* synthetic */ XForwardedHeadersConfig this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull XForwardedHeaderValues headers2) {
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                XForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, headers2, useLastProxy.1.INSTANCE);
            }
        });
    }

    public final void skipLastProxies(int proxiesCount) {
        this.extractEdgeProxy((Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit>)new Function2<MutableOriginConnectionPoint, XForwardedHeaderValues, Unit>(this, proxiesCount){
            final /* synthetic */ XForwardedHeadersConfig this$0;
            final /* synthetic */ int $proxiesCount;
            {
                this.this$0 = $receiver;
                this.$proxiesCount = $proxiesCount;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull XForwardedHeaderValues headers2) {
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                XForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, headers2, new Function1<List<? extends String>, String>(this.$proxiesCount){
                    final /* synthetic */ int $proxiesCount;
                    {
                        this.$proxiesCount = $proxiesCount;
                        super(1);
                    }

                    @Nullable
                    public final String invoke(@NotNull List<String> values2) {
                        String string;
                        Intrinsics.checkNotNullParameter(values2, "values");
                        List<String> list = values2;
                        int n = values2.size() - this.$proxiesCount - 1;
                        if (n >= 0 && n <= CollectionsKt.getLastIndex(list)) {
                            string = list.get(n);
                        } else {
                            int it = n;
                            boolean bl = false;
                            string = CollectionsKt.lastOrNull(values2);
                        }
                        return string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    }
                });
            }
        });
    }

    public final void skipKnownProxies(@NotNull List<String> hosts) {
        Intrinsics.checkNotNullParameter(hosts, "hosts");
        this.extractEdgeProxy((Function2<? super MutableOriginConnectionPoint, ? super XForwardedHeaderValues, Unit>)new Function2<MutableOriginConnectionPoint, XForwardedHeaderValues, Unit>(hosts, this){
            final /* synthetic */ List<String> $hosts;
            final /* synthetic */ XForwardedHeadersConfig this$0;
            {
                this.$hosts = $hosts;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MutableOriginConnectionPoint connectionPoint, @NotNull XForwardedHeaderValues headers2) {
                List list;
                Intrinsics.checkNotNullParameter(connectionPoint, "connectionPoint");
                Intrinsics.checkNotNullParameter(headers2, "headers");
                String string = headers2.getForHeader();
                if (string != null) {
                    char[] cArray = new char[]{','};
                    list = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
                } else {
                    list = null;
                }
                List forValues = list;
                Ref.IntRef proxiesCount = new Ref.IntRef();
                while (CollectionsKt.getLastIndex(this.$hosts) >= proxiesCount.element && forValues != null && CollectionsKt.getLastIndex(forValues) >= proxiesCount.element && Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)this.$hosts.get(this.$hosts.size() - proxiesCount.element - 1))).toString(), ((Object)StringsKt.trim((CharSequence)((String)forValues.get(forValues.size() - proxiesCount.element - 1)))).toString())) {
                    int n = proxiesCount.element;
                    proxiesCount.element = n + 1;
                }
                XForwardedHeadersConfig.access$setValues(this.this$0, connectionPoint, headers2, new Function1<List<? extends String>, String>(proxiesCount){
                    final /* synthetic */ Ref.IntRef $proxiesCount;
                    {
                        this.$proxiesCount = $proxiesCount;
                        super(1);
                    }

                    @Nullable
                    public final String invoke(@NotNull List<String> values2) {
                        String string;
                        Intrinsics.checkNotNullParameter(values2, "values");
                        List<String> list = values2;
                        int n = values2.size() - this.$proxiesCount.element - 1;
                        if (n >= 0 && n <= CollectionsKt.getLastIndex(list)) {
                            string = list.get(n);
                        } else {
                            int it = n;
                            boolean bl = false;
                            string = CollectionsKt.lastOrNull(values2);
                        }
                        return string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    }
                });
            }
        });
    }

    private final void setValues(MutableOriginConnectionPoint connectionPoint, XForwardedHeaderValues headers2, Function1<? super List<String>, String> extractValue) {
        block24: {
            String remoteHostOrAddress;
            List values2;
            List list;
            List list2;
            List list3;
            List list4;
            List list5;
            String string = headers2.getProtoHeader();
            if (string != null) {
                char[] cArray = new char[]{','};
                list5 = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
            } else {
                list5 = null;
            }
            List protoValues = list5;
            String string2 = headers2.getHttpsFlagHeader();
            if (string2 != null) {
                char[] cArray = new char[]{','};
                list4 = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
            } else {
                list4 = null;
            }
            List httpsFlagValues = list4;
            String string3 = headers2.getHostHeader();
            if (string3 != null) {
                char[] cArray = new char[]{','};
                list3 = StringsKt.split$default((CharSequence)string3, cArray, false, 0, 6, null);
            } else {
                list3 = null;
            }
            List hostValues = list3;
            String string4 = headers2.getPortHeader();
            if (string4 != null) {
                char[] cArray = new char[]{','};
                list2 = StringsKt.split$default((CharSequence)string4, cArray, false, 0, 6, null);
            } else {
                list2 = null;
            }
            List portValues = list2;
            String string5 = headers2.getForHeader();
            if (string5 != null) {
                char[] cArray = new char[]{','};
                list = StringsKt.split$default((CharSequence)string5, cArray, false, 0, 6, null);
            } else {
                list = null;
            }
            List forValues = list;
            List list6 = protoValues;
            if (list6 != null) {
                values2 = list6;
                boolean bl = false;
                String string6 = extractValue.invoke(values2);
                if (string6 != null) {
                    String scheme2 = string6;
                    connectionPoint.setScheme(scheme2);
                    URLProtocol uRLProtocol = URLProtocol.Companion.getByName().get(scheme2);
                    if (uRLProtocol != null) {
                        URLProtocol it = uRLProtocol;
                        boolean bl2 = false;
                        connectionPoint.setPort(it.getDefaultPort());
                        connectionPoint.setServerPort(it.getDefaultPort());
                    }
                }
            }
            List list7 = httpsFlagValues;
            if (list7 != null) {
                values2 = list7;
                boolean bl = false;
                boolean useHttps = this.toBoolean(extractValue.invoke(values2));
                if (useHttps) {
                    MutableOriginConnectionPoint route = connectionPoint;
                    boolean bl3 = false;
                    route.setScheme("https");
                    route.setPort(URLProtocol.Companion.getHTTPS().getDefaultPort());
                    route.setServerPort(URLProtocol.Companion.getHTTPS().getDefaultPort());
                }
            }
            List list8 = hostValues;
            if (list8 != null) {
                values2 = list8;
                boolean bl = false;
                String string7 = extractValue.invoke(values2);
                if (string7 != null) {
                    String hostAndPort = string7;
                    String host2 = StringsKt.substringBefore$default(hostAndPort, ':', null, 2, null);
                    String port2 = StringsKt.substringAfter(hostAndPort, ':', "");
                    connectionPoint.setHost(host2);
                    connectionPoint.setServerHost(host2);
                    Integer n = StringsKt.toIntOrNull(port2);
                    if (n != null) {
                        int it = ((Number)n).intValue();
                        boolean bl4 = false;
                        connectionPoint.setPort(it);
                        connectionPoint.setServerPort(it);
                    } else {
                        URLProtocol uRLProtocol = URLProtocol.Companion.getByName().get(connectionPoint.getScheme());
                        if (uRLProtocol != null) {
                            URLProtocol it = uRLProtocol;
                            boolean bl5 = false;
                            connectionPoint.setPort(it.getDefaultPort());
                            connectionPoint.setServerPort(it.getDefaultPort());
                        }
                    }
                }
            }
            List list9 = portValues;
            if (list9 != null) {
                values2 = list9;
                boolean bl = false;
                String string8 = extractValue.invoke(values2);
                if (string8 != null) {
                    String port3 = string8;
                    connectionPoint.setPort(Integer.parseInt(port3));
                    connectionPoint.setServerPort(Integer.parseInt(port3));
                }
            }
            List list10 = forValues;
            if (list10 == null) break block24;
            values2 = list10;
            boolean bl = false;
            String string9 = extractValue.invoke(values2);
            if (string9 != null && !StringsKt.isBlank(remoteHostOrAddress = string9)) {
                connectionPoint.setRemoteHost(remoteHostOrAddress);
                if (UtilsKt.isNotHostAddress(remoteHostOrAddress)) {
                    connectionPoint.setRemoteAddress(remoteHostOrAddress);
                }
            }
        }
    }

    private final boolean toBoolean(String $this$toBoolean) {
        return Intrinsics.areEqual($this$toBoolean, "yes") || Intrinsics.areEqual($this$toBoolean, "true") || Intrinsics.areEqual($this$toBoolean, "on");
    }

    public static final /* synthetic */ void access$setValues(XForwardedHeadersConfig $this, MutableOriginConnectionPoint connectionPoint, XForwardedHeaderValues headers2, Function1 extractValue) {
        $this.setValues(connectionPoint, headers2, extractValue);
    }
}

