/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.config.ApplicationConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/config/HoconApplicationConfig;", "Lio/ktor/server/config/ApplicationConfig;", "config", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "path", "", "configList", "", "keys", "", "property", "Lio/ktor/server/config/ApplicationConfigValue;", "propertyOrNull", "toMap", "", "", "HoconApplicationConfigValue", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nHoconApplicationConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n1549#2:100\n1620#2,3:101\n*S KotlinDebug\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n*L\n60#1:96\n60#1:97,3\n66#1:100\n66#1:101,3\n*E\n"})
public class HoconApplicationConfig
implements ApplicationConfig {
    @NotNull
    private final Config config;

    public HoconApplicationConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
    }

    @Override
    @NotNull
    public ApplicationConfigValue property(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (!this.config.hasPath(path)) {
            throw new ApplicationConfigurationException("Property " + path + " not found.");
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    @Override
    @Nullable
    public ApplicationConfigValue propertyOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (!this.config.hasPath(path)) {
            return null;
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ApplicationConfig> configList(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        List<? extends Config> list = this.config.getConfigList(path);
        Intrinsics.checkNotNullExpressionValue(list, "config.getConfigList(path)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Config config = (Config)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(new HoconApplicationConfig((Config)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ApplicationConfig config(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Config config = this.config.getConfig(path);
        Intrinsics.checkNotNullExpressionValue(config, "config.getConfig(path)");
        return new HoconApplicationConfig(config);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> keys() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<String, ConfigValue>> set2 = this.config.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "config.entrySet()");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Object object = this.config.root().unwrapped();
        Intrinsics.checkNotNullExpressionValue(object, "config.root().unwrapped()");
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/config/HoconApplicationConfig$HoconApplicationConfigValue;", "Lio/ktor/server/config/ApplicationConfigValue;", "config", "Lcom/typesafe/config/Config;", "path", "", "(Lcom/typesafe/config/Config;Ljava/lang/String;)V", "getConfig", "()Lcom/typesafe/config/Config;", "getPath", "()Ljava/lang/String;", "getList", "", "getString", "ktor-server-core"})
    private static final class HoconApplicationConfigValue
    implements ApplicationConfigValue {
        @NotNull
        private final Config config;
        @NotNull
        private final String path;

        public HoconApplicationConfigValue(@NotNull Config config, @NotNull String path) {
            Intrinsics.checkNotNullParameter(config, "config");
            Intrinsics.checkNotNullParameter(path, "path");
            this.config = config;
            this.path = path;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getString() {
            String string = this.config.getString(this.path);
            Intrinsics.checkNotNullExpressionValue(string, "config.getString(path)");
            return string;
        }

        @Override
        @NotNull
        public List<String> getList() {
            List<String> list = this.config.getStringList(this.path);
            Intrinsics.checkNotNullExpressionValue(list, "config.getStringList(path)");
            return list;
        }
    }
}

