/*
 * Decompiled with CFR 0.152.
 */
package dev.kobalt.proc2apiws.web.inputstream;

import dev.kobalt.proc2apiws.web.inputstream.InputStreamSizeLimitReachedException;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/kobalt/proc2apiws/web/inputstream/LimitedSizeInputStream;", "Ljava/io/FilterInputStream;", "Ljava/io/Closeable;", "inputStream", "Ljava/io/InputStream;", "maxSize", "", "(Ljava/io/InputStream;J)V", "currentSize", "checkSize", "", "close", "read", "", "b", "", "off", "len", "proc2apiws"})
@SourceDebugExtension(value={"SMAP\nLimitedSizeInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedSizeInputStream.kt\ndev/kobalt/proc2apiws/web/inputstream/LimitedSizeInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class LimitedSizeInputStream
extends FilterInputStream
implements Closeable {
    private final long maxSize;
    private long currentSize;

    public LimitedSizeInputStream(@NotNull InputStream inputStream2, long maxSize) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        super(inputStream2);
        this.maxSize = maxSize;
    }

    private final void checkSize() {
        if (this.currentSize > this.maxSize) {
            throw new InputStreamSizeLimitReachedException(this.maxSize, this.currentSize);
        }
    }

    @Override
    public int read() {
        int n;
        int it = n = super.read();
        boolean bl = false;
        if (it != -1) {
            long l = this.currentSize;
            this.currentSize = l + 1L;
        }
        this.checkSize();
        return n;
    }

    @Override
    public int read(@NotNull byte[] b2, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter(b2, "b");
        int it = n = super.read(b2, off, len);
        boolean bl = false;
        if (it > 0) {
            this.currentSize += (long)it;
        }
        this.checkSize();
        return n;
    }

    @Override
    public void close() {
        super.close();
    }
}

