/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.OriginType;
import com.typesafe.config.impl.SerializedConfigValue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class SimpleConfigOrigin
implements ConfigOrigin {
    private final String description;
    private final int lineNumber;
    private final int endLineNumber;
    private final OriginType originType;
    private final String urlOrNull;
    private final String resourceOrNull;
    private final List<String> commentsOrNull;
    static final String MERGE_OF_PREFIX = "merge of ";

    protected SimpleConfigOrigin(String description2, int lineNumber, int endLineNumber, OriginType originType, String urlOrNull, String resourceOrNull, List<String> commentsOrNull) {
        if (description2 == null) {
            throw new ConfigException.BugOrBroken("description may not be null");
        }
        this.description = description2;
        this.lineNumber = lineNumber;
        this.endLineNumber = endLineNumber;
        this.originType = originType;
        this.urlOrNull = urlOrNull;
        this.resourceOrNull = resourceOrNull;
        this.commentsOrNull = commentsOrNull;
    }

    static SimpleConfigOrigin newSimple(String description2) {
        return new SimpleConfigOrigin(description2, -1, -1, OriginType.GENERIC, null, null, null);
    }

    static SimpleConfigOrigin newFile(String filename) {
        String url2;
        try {
            url2 = new File(filename).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            url2 = null;
        }
        return new SimpleConfigOrigin(filename, -1, -1, OriginType.FILE, url2, null, null);
    }

    static SimpleConfigOrigin newURL(URL url2) {
        String u = url2.toExternalForm();
        return new SimpleConfigOrigin(u, -1, -1, OriginType.URL, u, null, null);
    }

    static SimpleConfigOrigin newResource(String resource2, URL url2) {
        String desc = url2 != null ? resource2 + " @ " + url2.toExternalForm() : resource2;
        return new SimpleConfigOrigin(desc, -1, -1, OriginType.RESOURCE, url2 != null ? url2.toExternalForm() : null, resource2, null);
    }

    static SimpleConfigOrigin newResource(String resource2) {
        return SimpleConfigOrigin.newResource(resource2, null);
    }

    @Override
    public SimpleConfigOrigin withLineNumber(int lineNumber) {
        if (lineNumber == this.lineNumber && lineNumber == this.endLineNumber) {
            return this;
        }
        return new SimpleConfigOrigin(this.description, lineNumber, lineNumber, this.originType, this.urlOrNull, this.resourceOrNull, this.commentsOrNull);
    }

    SimpleConfigOrigin addURL(URL url2) {
        return new SimpleConfigOrigin(this.description, this.lineNumber, this.endLineNumber, this.originType, url2 != null ? url2.toExternalForm() : null, this.resourceOrNull, this.commentsOrNull);
    }

    @Override
    public SimpleConfigOrigin withComments(List<String> comments) {
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull)) {
            return this;
        }
        return new SimpleConfigOrigin(this.description, this.lineNumber, this.endLineNumber, this.originType, this.urlOrNull, this.resourceOrNull, comments);
    }

    SimpleConfigOrigin prependComments(List<String> comments) {
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull) || comments == null) {
            return this;
        }
        if (this.commentsOrNull == null) {
            return this.withComments((List)comments);
        }
        ArrayList<String> merged = new ArrayList<String>(comments.size() + this.commentsOrNull.size());
        merged.addAll(comments);
        merged.addAll(this.commentsOrNull);
        return this.withComments(merged);
    }

    SimpleConfigOrigin appendComments(List<String> comments) {
        if (ConfigImplUtil.equalsHandlingNull(comments, this.commentsOrNull) || comments == null) {
            return this;
        }
        if (this.commentsOrNull == null) {
            return this.withComments((List)comments);
        }
        ArrayList<String> merged = new ArrayList<String>(comments.size() + this.commentsOrNull.size());
        merged.addAll(this.commentsOrNull);
        merged.addAll(comments);
        return this.withComments(merged);
    }

    @Override
    public String description() {
        if (this.lineNumber < 0) {
            return this.description;
        }
        if (this.endLineNumber == this.lineNumber) {
            return this.description + ": " + this.lineNumber;
        }
        return this.description + ": " + this.lineNumber + "-" + this.endLineNumber;
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleConfigOrigin) {
            SimpleConfigOrigin otherOrigin = (SimpleConfigOrigin)other;
            return this.description.equals(otherOrigin.description) && this.lineNumber == otherOrigin.lineNumber && this.endLineNumber == otherOrigin.endLineNumber && this.originType == otherOrigin.originType && ConfigImplUtil.equalsHandlingNull(this.urlOrNull, otherOrigin.urlOrNull) && ConfigImplUtil.equalsHandlingNull(this.resourceOrNull, otherOrigin.resourceOrNull);
        }
        return false;
    }

    public int hashCode() {
        int h = 41 * (41 + this.description.hashCode());
        h = 41 * (h + this.lineNumber);
        h = 41 * (h + this.endLineNumber);
        h = 41 * (h + this.originType.hashCode());
        if (this.urlOrNull != null) {
            h = 41 * (h + this.urlOrNull.hashCode());
        }
        if (this.resourceOrNull != null) {
            h = 41 * (h + this.resourceOrNull.hashCode());
        }
        return h;
    }

    public String toString() {
        return "ConfigOrigin(" + this.description + ")";
    }

    @Override
    public String filename() {
        if (this.originType == OriginType.FILE) {
            return this.description;
        }
        if (this.urlOrNull != null) {
            URL url2;
            try {
                url2 = new URL(this.urlOrNull);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (url2.getProtocol().equals("file")) {
                return url2.getFile();
            }
            return null;
        }
        return null;
    }

    @Override
    public URL url() {
        if (this.urlOrNull == null) {
            return null;
        }
        try {
            return new URL(this.urlOrNull);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String resource() {
        return this.resourceOrNull;
    }

    @Override
    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public List<String> comments() {
        if (this.commentsOrNull != null) {
            return Collections.unmodifiableList(this.commentsOrNull);
        }
        return Collections.emptyList();
    }

    private static SimpleConfigOrigin mergeTwo(SimpleConfigOrigin a2, SimpleConfigOrigin b2) {
        List<String> mergedComments;
        int mergedEndLine;
        int mergedStartLine;
        String mergedDesc;
        OriginType mergedType = a2.originType == b2.originType ? a2.originType : OriginType.GENERIC;
        String aDesc = a2.description;
        String bDesc = b2.description;
        if (aDesc.startsWith(MERGE_OF_PREFIX)) {
            aDesc = aDesc.substring(MERGE_OF_PREFIX.length());
        }
        if (bDesc.startsWith(MERGE_OF_PREFIX)) {
            bDesc = bDesc.substring(MERGE_OF_PREFIX.length());
        }
        if (aDesc.equals(bDesc)) {
            mergedDesc = aDesc;
            mergedStartLine = a2.lineNumber < 0 ? b2.lineNumber : (b2.lineNumber < 0 ? a2.lineNumber : Math.min(a2.lineNumber, b2.lineNumber));
            mergedEndLine = Math.max(a2.endLineNumber, b2.endLineNumber);
        } else {
            String aFull = a2.description();
            String bFull = b2.description();
            if (aFull.startsWith(MERGE_OF_PREFIX)) {
                aFull = aFull.substring(MERGE_OF_PREFIX.length());
            }
            if (bFull.startsWith(MERGE_OF_PREFIX)) {
                bFull = bFull.substring(MERGE_OF_PREFIX.length());
            }
            mergedDesc = MERGE_OF_PREFIX + aFull + "," + bFull;
            mergedStartLine = -1;
            mergedEndLine = -1;
        }
        String mergedURL = ConfigImplUtil.equalsHandlingNull(a2.urlOrNull, b2.urlOrNull) ? a2.urlOrNull : null;
        String mergedResource = ConfigImplUtil.equalsHandlingNull(a2.resourceOrNull, b2.resourceOrNull) ? a2.resourceOrNull : null;
        if (ConfigImplUtil.equalsHandlingNull(a2.commentsOrNull, b2.commentsOrNull)) {
            mergedComments = a2.commentsOrNull;
        } else {
            mergedComments = new ArrayList<String>();
            if (a2.commentsOrNull != null) {
                mergedComments.addAll(a2.commentsOrNull);
            }
            if (b2.commentsOrNull != null) {
                mergedComments.addAll(b2.commentsOrNull);
            }
        }
        return new SimpleConfigOrigin(mergedDesc, mergedStartLine, mergedEndLine, mergedType, mergedURL, mergedResource, mergedComments);
    }

    private static int similarity(SimpleConfigOrigin a2, SimpleConfigOrigin b2) {
        int count2 = 0;
        if (a2.originType == b2.originType) {
            ++count2;
        }
        if (a2.description.equals(b2.description)) {
            ++count2;
            if (a2.lineNumber == b2.lineNumber) {
                ++count2;
            }
            if (a2.endLineNumber == b2.endLineNumber) {
                ++count2;
            }
            if (ConfigImplUtil.equalsHandlingNull(a2.urlOrNull, b2.urlOrNull)) {
                ++count2;
            }
            if (ConfigImplUtil.equalsHandlingNull(a2.resourceOrNull, b2.resourceOrNull)) {
                ++count2;
            }
        }
        return count2;
    }

    private static SimpleConfigOrigin mergeThree(SimpleConfigOrigin a2, SimpleConfigOrigin b2, SimpleConfigOrigin c) {
        if (SimpleConfigOrigin.similarity(a2, b2) >= SimpleConfigOrigin.similarity(b2, c)) {
            return SimpleConfigOrigin.mergeTwo(SimpleConfigOrigin.mergeTwo(a2, b2), c);
        }
        return SimpleConfigOrigin.mergeTwo(a2, SimpleConfigOrigin.mergeTwo(b2, c));
    }

    static ConfigOrigin mergeOrigins(ConfigOrigin a2, ConfigOrigin b2) {
        return SimpleConfigOrigin.mergeTwo((SimpleConfigOrigin)a2, (SimpleConfigOrigin)b2);
    }

    static ConfigOrigin mergeOrigins(List<? extends AbstractConfigValue> stack) {
        ArrayList<SimpleConfigOrigin> origins = new ArrayList<SimpleConfigOrigin>(stack.size());
        for (AbstractConfigValue abstractConfigValue : stack) {
            origins.add(abstractConfigValue.origin());
        }
        return SimpleConfigOrigin.mergeOrigins(origins);
    }

    static ConfigOrigin mergeOrigins(Collection<? extends ConfigOrigin> stack) {
        if (stack.isEmpty()) {
            throw new ConfigException.BugOrBroken("can't merge empty list of origins");
        }
        if (stack.size() == 1) {
            return stack.iterator().next();
        }
        if (stack.size() == 2) {
            Iterator<? extends ConfigOrigin> i2 = stack.iterator();
            return SimpleConfigOrigin.mergeTwo((SimpleConfigOrigin)i2.next(), (SimpleConfigOrigin)i2.next());
        }
        ArrayList<SimpleConfigOrigin> remaining = new ArrayList<SimpleConfigOrigin>(stack.size());
        for (ConfigOrigin configOrigin : stack) {
            remaining.add((SimpleConfigOrigin)configOrigin);
        }
        while (remaining.size() > 2) {
            SimpleConfigOrigin c = (SimpleConfigOrigin)remaining.get(remaining.size() - 1);
            remaining.remove(remaining.size() - 1);
            SimpleConfigOrigin simpleConfigOrigin = (SimpleConfigOrigin)remaining.get(remaining.size() - 1);
            remaining.remove(remaining.size() - 1);
            SimpleConfigOrigin a2 = (SimpleConfigOrigin)remaining.get(remaining.size() - 1);
            remaining.remove(remaining.size() - 1);
            SimpleConfigOrigin merged = SimpleConfigOrigin.mergeThree(a2, simpleConfigOrigin, c);
            remaining.add(merged);
        }
        return SimpleConfigOrigin.mergeOrigins(remaining);
    }

    Map<SerializedConfigValue.SerializedField, Object> toFields() {
        EnumMap<SerializedConfigValue.SerializedField, Object> m = new EnumMap<SerializedConfigValue.SerializedField, Object>(SerializedConfigValue.SerializedField.class);
        m.put(SerializedConfigValue.SerializedField.ORIGIN_DESCRIPTION, this.description);
        if (this.lineNumber >= 0) {
            m.put(SerializedConfigValue.SerializedField.ORIGIN_LINE_NUMBER, Integer.valueOf(this.lineNumber));
        }
        if (this.endLineNumber >= 0) {
            m.put(SerializedConfigValue.SerializedField.ORIGIN_END_LINE_NUMBER, Integer.valueOf(this.endLineNumber));
        }
        m.put(SerializedConfigValue.SerializedField.ORIGIN_TYPE, Integer.valueOf(this.originType.ordinal()));
        if (this.urlOrNull != null) {
            m.put(SerializedConfigValue.SerializedField.ORIGIN_URL, this.urlOrNull);
        }
        if (this.resourceOrNull != null) {
            m.put(SerializedConfigValue.SerializedField.ORIGIN_RESOURCE, this.resourceOrNull);
        }
        if (this.commentsOrNull != null) {
            m.put(SerializedConfigValue.SerializedField.ORIGIN_COMMENTS, this.commentsOrNull);
        }
        return m;
    }

    Map<SerializedConfigValue.SerializedField, Object> toFieldsDelta(SimpleConfigOrigin baseOrigin) {
        Map<SerializedConfigValue.SerializedField, Object> baseFields = baseOrigin != null ? baseOrigin.toFields() : Collections.emptyMap();
        return SimpleConfigOrigin.fieldsDelta(baseFields, this.toFields());
    }

    static Map<SerializedConfigValue.SerializedField, Object> fieldsDelta(Map<SerializedConfigValue.SerializedField, Object> base2, Map<SerializedConfigValue.SerializedField, Object> child2) {
        EnumMap<SerializedConfigValue.SerializedField, Object> m = new EnumMap<SerializedConfigValue.SerializedField, Object>(child2);
        for (Map.Entry<SerializedConfigValue.SerializedField, Object> baseEntry : base2.entrySet()) {
            SerializedConfigValue.SerializedField f = baseEntry.getKey();
            if (m.containsKey((Object)f) && ConfigImplUtil.equalsHandlingNull(baseEntry.getValue(), m.get((Object)f))) {
                m.remove((Object)f);
                continue;
            }
            if (m.containsKey((Object)f)) continue;
            switch (f) {
                case ORIGIN_DESCRIPTION: {
                    throw new ConfigException.BugOrBroken("origin missing description field? " + child2);
                }
                case ORIGIN_LINE_NUMBER: {
                    m.put(SerializedConfigValue.SerializedField.ORIGIN_LINE_NUMBER, (Object)-1);
                    break;
                }
                case ORIGIN_END_LINE_NUMBER: {
                    m.put(SerializedConfigValue.SerializedField.ORIGIN_END_LINE_NUMBER, (Object)-1);
                    break;
                }
                case ORIGIN_TYPE: {
                    throw new ConfigException.BugOrBroken("should always be an ORIGIN_TYPE field");
                }
                case ORIGIN_URL: {
                    m.put(SerializedConfigValue.SerializedField.ORIGIN_NULL_URL, (Object)"");
                    break;
                }
                case ORIGIN_RESOURCE: {
                    m.put(SerializedConfigValue.SerializedField.ORIGIN_NULL_RESOURCE, (Object)"");
                    break;
                }
                case ORIGIN_COMMENTS: {
                    m.put(SerializedConfigValue.SerializedField.ORIGIN_NULL_COMMENTS, (Object)"");
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_RESOURCE: 
                case ORIGIN_NULL_COMMENTS: {
                    throw new ConfigException.BugOrBroken("computing delta, base object should not contain " + (Object)((Object)f) + " " + base2);
                }
                case END_MARKER: 
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case UNKNOWN: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new ConfigException.BugOrBroken("should not appear here: " + (Object)((Object)f));
                }
            }
        }
        return m;
    }

    static SimpleConfigOrigin fromFields(Map<SerializedConfigValue.SerializedField, Object> m) throws IOException {
        if (m.isEmpty()) {
            return null;
        }
        String description2 = (String)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_DESCRIPTION);
        Integer lineNumber = (Integer)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_LINE_NUMBER);
        Integer endLineNumber = (Integer)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_END_LINE_NUMBER);
        Number originTypeOrdinal = (Number)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_TYPE);
        if (originTypeOrdinal == null) {
            throw new IOException("Missing ORIGIN_TYPE field");
        }
        OriginType originType = OriginType.values()[originTypeOrdinal.byteValue()];
        String urlOrNull = (String)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_URL);
        String resourceOrNull = (String)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_RESOURCE);
        List commentsOrNull = (List)m.get((Object)SerializedConfigValue.SerializedField.ORIGIN_COMMENTS);
        if (originType == OriginType.RESOURCE && resourceOrNull == null) {
            resourceOrNull = description2;
        }
        return new SimpleConfigOrigin(description2, lineNumber != null ? lineNumber : -1, endLineNumber != null ? endLineNumber : -1, originType, urlOrNull, resourceOrNull, commentsOrNull);
    }

    static Map<SerializedConfigValue.SerializedField, Object> applyFieldsDelta(Map<SerializedConfigValue.SerializedField, Object> base2, Map<SerializedConfigValue.SerializedField, Object> delta) throws IOException {
        EnumMap<SerializedConfigValue.SerializedField, Object> m = new EnumMap<SerializedConfigValue.SerializedField, Object>(delta);
        for (Map.Entry<SerializedConfigValue.SerializedField, Object> baseEntry : base2.entrySet()) {
            SerializedConfigValue.SerializedField f = baseEntry.getKey();
            if (delta.containsKey((Object)f)) continue;
            switch (f) {
                case ORIGIN_DESCRIPTION: {
                    m.put(f, base2.get((Object)f));
                    break;
                }
                case ORIGIN_URL: {
                    if (delta.containsKey((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_URL)) {
                        m.remove((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_URL);
                        break;
                    }
                    m.put(f, base2.get((Object)f));
                    break;
                }
                case ORIGIN_RESOURCE: {
                    if (delta.containsKey((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_RESOURCE)) {
                        m.remove((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_RESOURCE);
                        break;
                    }
                    m.put(f, base2.get((Object)f));
                    break;
                }
                case ORIGIN_COMMENTS: {
                    if (delta.containsKey((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_COMMENTS)) {
                        m.remove((Object)SerializedConfigValue.SerializedField.ORIGIN_NULL_COMMENTS);
                        break;
                    }
                    m.put(f, base2.get((Object)f));
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_RESOURCE: 
                case ORIGIN_NULL_COMMENTS: {
                    throw new ConfigException.BugOrBroken("applying fields, base object should not contain " + (Object)((Object)f) + " " + base2);
                }
                case ORIGIN_LINE_NUMBER: 
                case ORIGIN_END_LINE_NUMBER: 
                case ORIGIN_TYPE: {
                    m.put(f, base2.get((Object)f));
                    break;
                }
                case END_MARKER: 
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case UNKNOWN: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new ConfigException.BugOrBroken("should not appear here: " + (Object)((Object)f));
                }
            }
        }
        return m;
    }

    static SimpleConfigOrigin fromBase(SimpleConfigOrigin baseOrigin, Map<SerializedConfigValue.SerializedField, Object> delta) throws IOException {
        Map<SerializedConfigValue.SerializedField, Object> baseFields = baseOrigin != null ? baseOrigin.toFields() : Collections.emptyMap();
        Map<SerializedConfigValue.SerializedField, Object> fields2 = SimpleConfigOrigin.applyFieldsDelta(baseFields, delta);
        return SimpleConfigOrigin.fromFields(fields2);
    }
}

