/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class AbstractConfigValue
implements ConfigValue,
MergeableValue {
    private final SimpleConfigOrigin origin;

    AbstractConfigValue(ConfigOrigin origin2) {
        this.origin = (SimpleConfigOrigin)origin2;
    }

    @Override
    public SimpleConfigOrigin origin() {
        return this.origin;
    }

    ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context, ResolveSource source2) throws NotPossibleToResolve {
        return ResolveResult.make(context, this);
    }

    ResolveStatus resolveStatus() {
        return ResolveStatus.RESOLVED;
    }

    protected static List<AbstractConfigValue> replaceChildInList(List<AbstractConfigValue> list, AbstractConfigValue child2, AbstractConfigValue replacement) {
        int i2;
        for (i2 = 0; i2 < list.size() && list.get(i2) != child2; ++i2) {
        }
        if (i2 == list.size()) {
            throw new ConfigException.BugOrBroken("tried to replace " + child2 + " which is not in " + list);
        }
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>(list);
        if (replacement != null) {
            newStack.set(i2, replacement);
        } else {
            newStack.remove(i2);
        }
        if (newStack.isEmpty()) {
            return null;
        }
        return newStack;
    }

    protected static boolean hasDescendantInList(List<AbstractConfigValue> list, AbstractConfigValue descendant) {
        for (AbstractConfigValue v : list) {
            if (v != descendant) continue;
            return true;
        }
        for (AbstractConfigValue v : list) {
            if (!(v instanceof Container) || !((Container)((Object)v)).hasDescendant(descendant)) continue;
            return true;
        }
        return false;
    }

    AbstractConfigValue relativized(Path prefix2) {
        return this;
    }

    @Override
    public AbstractConfigValue toFallbackValue() {
        return this;
    }

    protected abstract AbstractConfigValue newCopy(ConfigOrigin var1);

    protected boolean ignoresFallbacks() {
        return this.resolveStatus() == ResolveStatus.RESOLVED;
    }

    protected AbstractConfigValue withFallbacksIgnored() {
        if (this.ignoresFallbacks()) {
            return this;
        }
        throw new ConfigException.BugOrBroken("value class doesn't implement forced fallback-ignoring " + this);
    }

    protected final void requireNotIgnoringFallbacks() {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("method should not have been called with ignoresFallbacks=true " + this.getClass().getSimpleName());
        }
    }

    protected AbstractConfigValue constructDelayedMerge(ConfigOrigin origin2, List<AbstractConfigValue> stack) {
        return new ConfigDelayedMerge(origin2, stack);
    }

    protected final AbstractConfigValue mergedWithTheUnmergeable(Collection<AbstractConfigValue> stack, Unmergeable fallback) {
        this.requireNotIgnoringFallbacks();
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        newStack.addAll(stack);
        newStack.addAll(fallback.unmergedValues());
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), newStack);
    }

    private final AbstractConfigValue delayMerge(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback) {
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        newStack.addAll(stack);
        newStack.add(fallback);
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), newStack);
    }

    protected final AbstractConfigValue mergedWithObject(Collection<AbstractConfigValue> stack, AbstractConfigObject fallback) {
        this.requireNotIgnoringFallbacks();
        if (this instanceof AbstractConfigObject) {
            throw new ConfigException.BugOrBroken("Objects must reimplement mergedWithObject");
        }
        return this.mergedWithNonObject(stack, fallback);
    }

    protected final AbstractConfigValue mergedWithNonObject(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback) {
        this.requireNotIgnoringFallbacks();
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return this.withFallbacksIgnored();
        }
        return this.delayMerge(stack, fallback);
    }

    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable fallback) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithTheUnmergeable(Collections.singletonList(this), fallback);
    }

    protected AbstractConfigValue mergedWithObject(AbstractConfigObject fallback) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithObject(Collections.singletonList(this), fallback);
    }

    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue fallback) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithNonObject(Collections.singletonList(this), fallback);
    }

    @Override
    public AbstractConfigValue withOrigin(ConfigOrigin origin2) {
        if (this.origin == origin2) {
            return this;
        }
        return this.newCopy(origin2);
    }

    @Override
    public AbstractConfigValue withFallback(ConfigMergeable mergeable) {
        if (this.ignoresFallbacks()) {
            return this;
        }
        ConfigValue other = ((MergeableValue)mergeable).toFallbackValue();
        if (other instanceof Unmergeable) {
            return this.mergedWithTheUnmergeable((Unmergeable)((Object)other));
        }
        if (other instanceof AbstractConfigObject) {
            return this.mergedWithObject((AbstractConfigObject)other);
        }
        return this.mergedWithNonObject((AbstractConfigValue)other);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigValue;
    }

    public boolean equals(Object other) {
        if (other instanceof ConfigValue) {
            return this.canEqual(other) && this.valueType() == ((ConfigValue)other).valueType() && ConfigImplUtil.equalsHandlingNull(this.unwrapped(), ((ConfigValue)other).unwrapped());
        }
        return false;
    }

    public int hashCode() {
        Object o = this.unwrapped();
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0, true, null, ConfigRenderOptions.concise());
        return this.getClass().getSimpleName() + "(" + sb.toString() + ")";
    }

    protected static void indent(StringBuilder sb, int indent, ConfigRenderOptions options2) {
        if (options2.getFormatted()) {
            for (int remaining = indent; remaining > 0; --remaining) {
                sb.append("    ");
            }
        }
    }

    protected void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options2) {
        if (atKey != null) {
            String renderedKey = options2.getJson() ? ConfigImplUtil.renderJsonString(atKey) : ConfigImplUtil.renderStringUnquotedIfPossible(atKey);
            sb.append(renderedKey);
            if (options2.getJson()) {
                if (options2.getFormatted()) {
                    sb.append(" : ");
                } else {
                    sb.append(":");
                }
            } else if (this instanceof ConfigObject) {
                if (options2.getFormatted()) {
                    sb.append(' ');
                }
            } else {
                sb.append("=");
            }
        }
        this.render(sb, indent, atRoot, options2);
    }

    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options2) {
        Object u = this.unwrapped();
        sb.append(u.toString());
    }

    @Override
    public final String render() {
        return this.render(ConfigRenderOptions.defaults());
    }

    @Override
    public final String render(ConfigRenderOptions options2) {
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0, true, null, options2);
        return sb.toString();
    }

    String transformToString() {
        return null;
    }

    SimpleConfig atKey(ConfigOrigin origin2, String key2) {
        Map<String, AbstractConfigValue> m = Collections.singletonMap(key2, this);
        return new SimpleConfigObject(origin2, m).toConfig();
    }

    @Override
    public SimpleConfig atKey(String key2) {
        return this.atKey(SimpleConfigOrigin.newSimple("atKey(" + key2 + ")"), key2);
    }

    SimpleConfig atPath(ConfigOrigin origin2, Path path) {
        SimpleConfig result2 = this.atKey(origin2, path.last());
        for (Path parent = path.parent(); parent != null; parent = parent.parent()) {
            String key2 = parent.last();
            result2 = result2.atKey(origin2, key2);
        }
        return result2;
    }

    @Override
    public SimpleConfig atPath(String pathExpression) {
        SimpleConfigOrigin origin2 = SimpleConfigOrigin.newSimple("atPath(" + pathExpression + ")");
        return this.atPath(origin2, Path.newPath(pathExpression));
    }

    protected abstract class NoExceptionsModifier
    implements Modifier {
        protected NoExceptionsModifier() {
        }

        @Override
        public final AbstractConfigValue modifyChildMayThrow(String keyOrNull, AbstractConfigValue v) throws Exception {
            try {
                return this.modifyChild(keyOrNull, v);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException.BugOrBroken("Unexpected exception", e);
            }
        }

        abstract AbstractConfigValue modifyChild(String var1, AbstractConfigValue var2);
    }

    protected static interface Modifier {
        public AbstractConfigValue modifyChildMayThrow(String var1, AbstractConfigValue var2) throws Exception;
    }

    static class NotPossibleToResolve
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String traceString;

        NotPossibleToResolve(ResolveContext context) {
            super("was not possible to resolve");
            this.traceString = context.traceString();
        }

        String traceString() {
            return this.traceString;
        }
    }
}

